/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.VerificationTestUtils;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

@Deprecated
public class LegacyMockedSingleListenerRule<T>
implements TestRule {
    @Nullable
    private SingleSource.Subscriber<? super T> subscriber;
    @Nullable
    private volatile Cancellable onSubscribeResult;

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LegacyMockedSingleListenerRule.this.resetSubscriberMock();
                base.evaluate();
            }
        };
    }

    public LegacyMockedSingleListenerRule<T> resetSubscriberMock() {
        this.subscriber = (SingleSource.Subscriber)Mockito.mock(SingleSource.Subscriber.class);
        ((SingleSource.Subscriber)Mockito.doAnswer(invocation -> {
            this.onSubscribeResult = (Cancellable)invocation.getArgument(0);
            return null;
        }).when(this.subscriber)).onSubscribe((Cancellable)ArgumentMatchers.any(Cancellable.class));
        return this;
    }

    public LegacyMockedSingleListenerRule<T> cancel() {
        this.verifyCancellable();
        Cancellable listenResult = this.onSubscribeResult;
        assert (listenResult != null);
        listenResult.cancel();
        return this;
    }

    public LegacyMockedSingleListenerRule<T> listen(Single<? extends T> src) {
        assert (this.subscriber != null);
        SourceAdapters.toSource(src).subscribe(this.subscriber);
        return this;
    }

    public LegacyMockedSingleListenerRule<T> verifySuccess(@Nullable T expected) {
        this.verifyCancellable();
        InOrder verifier = this.inOrderVerifier();
        ((SingleSource.Subscriber)verifier.verify(this.subscriber)).onSuccess(expected);
        verifier.verifyNoMoreInteractions();
        return this;
    }

    public T verifySuccessAndReturn(Class<T> returnClass) {
        this.verifyCancellable();
        InOrder verifier = this.inOrderVerifier();
        ArgumentCaptor captor = ArgumentCaptor.forClass(returnClass);
        ((SingleSource.Subscriber)verifier.verify(this.subscriber)).onSuccess(captor.capture());
        verifier.verifyNoMoreInteractions();
        return (T)captor.getValue();
    }

    public LegacyMockedSingleListenerRule<T> verifyFailure(Throwable cause) {
        this.verifyCancellable();
        InOrder verifier = this.inOrderVerifier();
        ((SingleSource.Subscriber)verifier.verify(this.subscriber)).onError(cause);
        verifier.verifyNoMoreInteractions();
        return this;
    }

    public LegacyMockedSingleListenerRule<T> verifyFailure(ArgumentCaptor<Throwable> causeCaptor) {
        this.verifyCancellable();
        InOrder verifier = this.inOrderVerifier();
        ((SingleSource.Subscriber)verifier.verify(this.subscriber)).onError((Throwable)causeCaptor.capture());
        verifier.verifyNoMoreInteractions();
        return this;
    }

    public LegacyMockedSingleListenerRule<T> verifyFailure(Class<? extends Throwable> cause) {
        this.verifyCancellable();
        InOrder verifier = this.inOrderVerifier();
        ((SingleSource.Subscriber)verifier.verify(this.subscriber)).onError((Throwable)ArgumentMatchers.any(cause));
        verifier.verifyNoMoreInteractions();
        return this;
    }

    public LegacyMockedSingleListenerRule<T> verifyNoEmissions() {
        assert (this.subscriber != null);
        ((SingleSource.Subscriber)Mockito.verify(this.subscriber)).onSubscribe((Cancellable)ArgumentMatchers.any());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.subscriber});
        return this;
    }

    public LegacyMockedSingleListenerRule<T> verifySuppressedFailure(Throwable originalCause, Throwable suppressedCause) {
        this.verifyCancellable();
        InOrder verifier = this.inOrderVerifier();
        ArgumentCaptor throwableCaptor = ArgumentCaptor.forClass(Throwable.class);
        ((SingleSource.Subscriber)verifier.verify(this.subscriber)).onError((Throwable)throwableCaptor.capture());
        Throwable actualCause = (Throwable)throwableCaptor.getValue();
        VerificationTestUtils.verifyOriginalAndSuppressedCauses(actualCause, originalCause, suppressedCause);
        verifier.verifyNoMoreInteractions();
        return this;
    }

    public LegacyMockedSingleListenerRule<T> verifySuppressedFailure(Throwable suppressedCause) {
        this.verifyCancellable();
        InOrder verifier = this.inOrderVerifier();
        ArgumentCaptor throwableCaptor = ArgumentCaptor.forClass(Throwable.class);
        ((SingleSource.Subscriber)verifier.verify(this.subscriber)).onError((Throwable)throwableCaptor.capture());
        Throwable actualCause = (Throwable)throwableCaptor.getValue();
        VerificationTestUtils.verifySuppressed(actualCause, suppressedCause);
        verifier.verifyNoMoreInteractions();
        return this;
    }

    public LegacyMockedSingleListenerRule<T> noMoreInteractions() {
        this.verifyCancellable();
        assert (this.subscriber != null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.subscriber});
        return this;
    }

    private LegacyMockedSingleListenerRule<T> verifyCancellable() {
        MatcherAssert.assertThat((String)"Listen result not found.", (Object)this.onSubscribeResult, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        return this;
    }

    private InOrder inOrderVerifier() {
        assert (this.subscriber != null);
        InOrder verifier = Mockito.inOrder((Object[])new Object[]{this.subscriber});
        ((SingleSource.Subscriber)verifier.verify(this.subscriber)).onSubscribe((Cancellable)ArgumentMatchers.any());
        return verifier;
    }
}

