/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.VerificationTestUtils;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

@Deprecated
public class LegacyMockedCompletableListenerRule
implements TestRule {
    @Nullable
    private CompletableSource.Subscriber subscriber;
    @Nullable
    private Cancellable cancellable;

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LegacyMockedCompletableListenerRule.this.createSubscriber();
                base.evaluate();
            }
        };
    }

    public LegacyMockedCompletableListenerRule cancel() {
        this.verifyCancellable();
        assert (this.cancellable != null);
        this.cancellable.cancel();
        return this;
    }

    public LegacyMockedCompletableListenerRule listen(Completable src) {
        return this.listen(src, true);
    }

    public LegacyMockedCompletableListenerRule listen(Completable src, boolean expectOnSubscribe) {
        this.createSubscriber();
        assert (this.subscriber != null);
        SourceAdapters.toSource((Completable)src).subscribe(this.subscriber);
        if (expectOnSubscribe) {
            ArgumentCaptor cancellableCaptor = ArgumentCaptor.forClass(Cancellable.class);
            ((CompletableSource.Subscriber)Mockito.verify((Object)this.subscriber)).onSubscribe((Cancellable)cancellableCaptor.capture());
            this.cancellable = (Cancellable)cancellableCaptor.getValue();
            return this.verifyCancellable();
        }
        return this;
    }

    public LegacyMockedCompletableListenerRule verifyCancelled() {
        assert (this.cancellable != null);
        ((Cancellable)Mockito.verify((Object)this.cancellable)).cancel();
        return this;
    }

    public LegacyMockedCompletableListenerRule verifyCompletion() {
        InOrder verifier = this.inOrderVerifier();
        ((CompletableSource.Subscriber)verifier.verify((Object)this.subscriber)).onComplete();
        verifier.verifyNoMoreInteractions();
        return this;
    }

    public LegacyMockedCompletableListenerRule verifyFailure(Throwable cause) {
        InOrder verifier = this.inOrderVerifier();
        ((CompletableSource.Subscriber)verifier.verify((Object)this.subscriber)).onError(cause);
        verifier.verifyNoMoreInteractions();
        return this;
    }

    public LegacyMockedCompletableListenerRule verifyFailure(ArgumentCaptor<Throwable> causeCaptor) {
        InOrder verifier = this.inOrderVerifier();
        ((CompletableSource.Subscriber)verifier.verify((Object)this.subscriber)).onError((Throwable)causeCaptor.capture());
        verifier.verifyNoMoreInteractions();
        return this;
    }

    public LegacyMockedCompletableListenerRule verifyFailure(Class<? extends Throwable> cause) {
        InOrder verifier = this.inOrderVerifier();
        ((CompletableSource.Subscriber)verifier.verify((Object)this.subscriber)).onError((Throwable)ArgumentMatchers.any(cause));
        verifier.verifyNoMoreInteractions();
        return this;
    }

    public LegacyMockedCompletableListenerRule verifySuppressedFailure(Throwable originalCause, Throwable suppressedCause) {
        InOrder verifier = this.inOrderVerifier();
        ArgumentCaptor throwableCaptor = ArgumentCaptor.forClass(Throwable.class);
        ((CompletableSource.Subscriber)verifier.verify((Object)this.subscriber)).onError((Throwable)throwableCaptor.capture());
        Throwable actualCause = (Throwable)throwableCaptor.getValue();
        VerificationTestUtils.verifyOriginalAndSuppressedCauses(actualCause, originalCause, suppressedCause);
        verifier.verifyNoMoreInteractions();
        return this;
    }

    public LegacyMockedCompletableListenerRule verifySuppressedFailure(Class<? extends Throwable> orginalCause, Class<? extends Throwable> suppressedCause) {
        InOrder verifier = this.inOrderVerifier();
        ArgumentCaptor throwableCaptor = ArgumentCaptor.forClass(Throwable.class);
        ((CompletableSource.Subscriber)verifier.verify((Object)this.subscriber)).onError((Throwable)throwableCaptor.capture());
        Throwable actualCause = (Throwable)throwableCaptor.getValue();
        MatcherAssert.assertThat((Object)actualCause, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(orginalCause)));
        MatcherAssert.assertThat((Object)actualCause.getSuppressed(), (Matcher)Matchers.arrayContaining((Matcher[])new Matcher[]{Matchers.instanceOf(suppressedCause)}));
        verifier.verifyNoMoreInteractions();
        return this;
    }

    public LegacyMockedCompletableListenerRule verifySuppressedFailure(Throwable suppressedCause) {
        InOrder verifier = this.inOrderVerifier();
        ArgumentCaptor throwableCaptor = ArgumentCaptor.forClass(Throwable.class);
        ((CompletableSource.Subscriber)verifier.verify((Object)this.subscriber)).onError((Throwable)throwableCaptor.capture());
        Throwable actualCause = (Throwable)throwableCaptor.getValue();
        VerificationTestUtils.verifySuppressed(actualCause, suppressedCause);
        verifier.verifyNoMoreInteractions();
        return this;
    }

    public LegacyMockedCompletableListenerRule verifyNoEmissions() {
        ((CompletableSource.Subscriber)Mockito.verify((Object)this.subscriber)).onSubscribe((Cancellable)ArgumentMatchers.any());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.subscriber});
        return this;
    }

    public LegacyMockedCompletableListenerRule reset() {
        this.subscriber = (CompletableSource.Subscriber)Mockito.mock(CompletableSource.Subscriber.class);
        return this;
    }

    private LegacyMockedCompletableListenerRule verifyCancellable() {
        MatcherAssert.assertThat((String)"Cancellable not found.", (Object)this.cancellable, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        return this;
    }

    private void createSubscriber() {
        this.subscriber = (CompletableSource.Subscriber)Mockito.mock(CompletableSource.Subscriber.class);
    }

    private InOrder inOrderVerifier() {
        assert (this.subscriber != null);
        InOrder verifier = Mockito.inOrder((Object[])new Object[]{this.subscriber});
        ((CompletableSource.Subscriber)verifier.verify((Object)this.subscriber)).onSubscribe((Cancellable)ArgumentMatchers.any());
        return verifier;
    }
}

