/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.concurrent.internal.TerminalNotification;
import javax.annotation.Nullable;

final class CollectingSingleSubscriber<T>
implements SingleSource.Subscriber<T>,
Cancellable {
    public static final Object NULL_RESULT = new Object();
    private final DelayedCancellable cancellable = new DelayedCancellable();
    @Nullable
    private volatile Object terminal;
    private volatile boolean cancellableReceived;

    CollectingSingleSubscriber() {
    }

    public boolean cancellableReceived() {
        return this.cancellableReceived;
    }

    public Cancellable cancellable() {
        return this.cancellable;
    }

    public boolean hasResult() {
        return this.terminal != null && !(this.terminal instanceof TerminalNotification);
    }

    @Nullable
    public T result() {
        if (this.terminal instanceof TerminalNotification || this.terminal == NULL_RESULT) {
            return null;
        }
        return (T)this.terminal;
    }

    @Nullable
    public T takeResult() {
        Object terminal = this.terminal;
        if (terminal instanceof TerminalNotification) {
            return null;
        }
        this.terminal = null;
        return (T)(terminal == NULL_RESULT ? null : terminal);
    }

    @Nullable
    public Throwable error() {
        Object terminal = this.terminal;
        if (!(terminal instanceof TerminalNotification)) {
            return null;
        }
        return ((TerminalNotification)terminal).cause();
    }

    @Nullable
    public Throwable takeError() {
        Object terminal = this.terminal;
        if (!(terminal instanceof TerminalNotification)) {
            return null;
        }
        this.terminal = null;
        return ((TerminalNotification)terminal).cause();
    }

    public boolean isSuccess() {
        return this.hasResult();
    }

    public boolean isErrored() {
        return this.terminal instanceof TerminalNotification;
    }

    public void cancel() {
        this.cancellable.cancel();
    }

    public void onSubscribe(Cancellable s) {
        this.cancellable.delayedCancellable(s);
        this.cancellableReceived = true;
    }

    public void onSuccess(T result) {
        this.terminal = result != null ? result : NULL_RESULT;
    }

    public void onError(Throwable t) {
        this.terminal = TerminalNotification.error((Throwable)t);
    }
}

