/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.internal.DelayedSubscription;
import io.servicetalk.concurrent.internal.TerminalNotification;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;

final class CollectingPublisherSubscriber<T>
implements PublisherSource.Subscriber<T>,
PublisherSource.Subscription {
    private final List<T> items = new CopyOnWriteArrayList<T>();
    private final DelayedSubscription subscription = new DelayedSubscription();
    @Nullable
    private volatile TerminalNotification terminal;
    private volatile boolean subscriptionReceived;

    CollectingPublisherSubscriber() {
    }

    public boolean subscriptionReceived() {
        return this.subscriptionReceived;
    }

    public PublisherSource.Subscription subscription() {
        return this.subscription;
    }

    public List<T> items() {
        return new ArrayList<T>(this.items);
    }

    public List<T> takeItems() {
        ArrayList<T> items = new ArrayList<T>(this.items);
        this.items.clear();
        return items;
    }

    @Nullable
    public TerminalNotification terminal() {
        return this.terminal;
    }

    @Nullable
    public TerminalNotification takeTerminal() {
        TerminalNotification terminal = this.terminal;
        this.terminal = null;
        return terminal;
    }

    @Nullable
    public Throwable error() {
        TerminalNotification terminal = this.terminal;
        if (terminal == null) {
            return null;
        }
        return terminal == TerminalNotification.complete() ? null : terminal.cause();
    }

    @Nullable
    public Throwable takeError() {
        Throwable error = this.error();
        this.terminal = null;
        return error;
    }

    public boolean isCompleted() {
        return this.terminal == TerminalNotification.complete();
    }

    public boolean isErrored() {
        TerminalNotification terminal = this.terminal;
        return terminal != null && terminal != TerminalNotification.complete();
    }

    public boolean isTerminated() {
        return this.terminal != null;
    }

    public void request(long n) {
        this.subscription.request(n);
    }

    public void cancel() {
        this.subscription.cancel();
    }

    public void onSubscribe(PublisherSource.Subscription s) {
        this.subscription.delayedSubscription(s);
        this.subscriptionReceived = true;
    }

    public void onNext(T item) {
        this.items.add(item);
    }

    public void onError(Throwable t) {
        this.terminal = TerminalNotification.error((Throwable)t);
    }

    public void onComplete() {
        this.terminal = TerminalNotification.complete();
    }
}

