/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.concurrent.internal.TerminalNotification;
import javax.annotation.Nullable;

final class CollectingCompletableSubscriber
implements CompletableSource.Subscriber,
Cancellable {
    private final DelayedCancellable cancellable = new DelayedCancellable();
    @Nullable
    private volatile TerminalNotification terminal;
    private volatile boolean cancellableReceived;

    CollectingCompletableSubscriber() {
    }

    public boolean cancellableReceived() {
        return this.cancellableReceived;
    }

    public Cancellable cancellable() {
        return this.cancellable;
    }

    @Nullable
    public TerminalNotification terminal() {
        return this.terminal;
    }

    @Nullable
    public TerminalNotification takeTerminal() {
        TerminalNotification terminal = this.terminal;
        this.terminal = null;
        return terminal;
    }

    @Nullable
    public Throwable error() {
        TerminalNotification terminal = this.terminal;
        if (terminal == null) {
            return null;
        }
        return terminal == TerminalNotification.complete() ? null : terminal.cause();
    }

    @Nullable
    public Throwable takeError() {
        Throwable error = this.error();
        this.terminal = null;
        return error;
    }

    public boolean isCompleted() {
        return this.terminal == TerminalNotification.complete();
    }

    public boolean isErrored() {
        TerminalNotification terminal = this.terminal;
        return terminal != null && terminal != TerminalNotification.complete();
    }

    public boolean isTerminated() {
        return this.terminal != null;
    }

    public void cancel() {
        this.cancellable.cancel();
    }

    public void onSubscribe(Cancellable s) {
        this.cancellable.delayedCancellable(s);
        this.cancellableReceived = true;
    }

    public void onComplete() {
        this.terminal = TerminalNotification.complete();
    }

    public void onError(Throwable t) {
        this.terminal = TerminalNotification.error((Throwable)t);
    }
}

