/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSslCertificateCompressionConfig;
import io.netty.handler.ssl.OpenSslContextOption;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslContextOption;
import io.netty.handler.ssl.SslProvider;
import io.servicetalk.transport.api.CertificateCompressionAlgorithm;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.SslConfig;
import io.servicetalk.transport.netty.internal.BuilderUtils;
import io.servicetalk.transport.netty.internal.SslUtils;
import io.servicetalk.transport.netty.internal.ZlibOpenSslCertificateCompressionAlgorithm;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SslContextFactory {
    private static final Logger LOGGER;
    @Nullable
    private static final MethodHandle SSL_PROVIDER_OPTION_SUPPORTED;

    private SslContextFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SslContext forClient(ClientSslConfig config) {
        SslContextBuilder builder = SslContextBuilder.forClient().sessionCacheSize(config.sessionCacheSize()).sessionTimeout(config.sessionTimeout());
        SslContextFactory.configureTrustManager(config, builder);
        KeyManagerFactory keyManagerFactory = config.keyManagerFactory();
        if (keyManagerFactory != null) {
            builder.keyManager(keyManagerFactory);
        } else {
            InputStream keyCertChainSupplier = null;
            InputStream keySupplier = null;
            try {
                keyCertChainSupplier = SslContextFactory.supplierNullSafe(config.keyCertChainSupplier());
                keySupplier = SslContextFactory.supplierNullSafe(config.keySupplier());
                builder.keyManager(keyCertChainSupplier, keySupplier, config.keyPassword());
            }
            catch (Throwable throwable) {
                try {
                    BuilderUtils.closeAndRethrowUnchecked(keyCertChainSupplier);
                    throw throwable;
                }
                finally {
                    BuilderUtils.closeAndRethrowUnchecked(keySupplier);
                }
            }
            try {
                BuilderUtils.closeAndRethrowUnchecked(keyCertChainSupplier);
            }
            finally {
                BuilderUtils.closeAndRethrowUnchecked(keySupplier);
            }
        }
        List<String> alpnProtocols = config.alpnProtocols();
        SslProvider nettySslProvider = SslUtils.toNettySslProvider(config.provider(), alpnProtocols != null && !alpnProtocols.isEmpty());
        builder.sslProvider(nettySslProvider);
        builder.protocols(config.sslProtocols());
        builder.ciphers(config.ciphers());
        builder.applicationProtocolConfig(SslUtils.nettyApplicationProtocol(alpnProtocols));
        SslContextFactory.configureCertificateCompression(config, builder, nettySslProvider, false);
        try {
            return builder.build();
        }
        catch (SSLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SslContext forServer(ServerSslConfig config) {
        SslContextBuilder builder;
        KeyManagerFactory keyManagerFactory = config.keyManagerFactory();
        if (keyManagerFactory != null) {
            builder = SslContextBuilder.forServer(keyManagerFactory);
        } else {
            InputStream keyCertChainSupplier = null;
            InputStream keySupplier = null;
            try {
                keyCertChainSupplier = SslContextFactory.supplierNullSafe(config.keyCertChainSupplier());
                keySupplier = SslContextFactory.supplierNullSafe(config.keySupplier());
                builder = SslContextBuilder.forServer(keyCertChainSupplier, keySupplier, config.keyPassword());
            }
            catch (Throwable throwable) {
                try {
                    BuilderUtils.closeAndRethrowUnchecked(keyCertChainSupplier);
                    throw throwable;
                }
                finally {
                    BuilderUtils.closeAndRethrowUnchecked(keySupplier);
                }
            }
            try {
                BuilderUtils.closeAndRethrowUnchecked(keyCertChainSupplier);
            }
            finally {
                BuilderUtils.closeAndRethrowUnchecked(keySupplier);
            }
        }
        List<String> alpnProtocols = config.alpnProtocols();
        builder.sessionCacheSize(config.sessionCacheSize()).sessionTimeout(config.sessionTimeout()).applicationProtocolConfig(SslUtils.nettyApplicationProtocol(alpnProtocols));
        switch (config.clientAuthMode()) {
            case NONE: {
                builder.clientAuth(ClientAuth.NONE);
                break;
            }
            case OPTIONAL: {
                builder.clientAuth(ClientAuth.OPTIONAL);
                break;
            }
            case REQUIRE: {
                builder.clientAuth(ClientAuth.REQUIRE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported: " + (Object)((Object)config.clientAuthMode()));
            }
        }
        SslContextFactory.configureTrustManager(config, builder);
        builder.protocols(config.sslProtocols());
        builder.ciphers(config.ciphers());
        SslProvider nettySslProvider = SslUtils.toNettySslProvider(config.provider(), alpnProtocols != null && !alpnProtocols.isEmpty());
        builder.sslProvider(nettySslProvider);
        SslContextFactory.configureCertificateCompression(config, builder, nettySslProvider, true);
        try {
            return builder.build();
        }
        catch (SSLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static void configureTrustManager(SslConfig config, SslContextBuilder builder) {
        if (config.trustManagerFactory() != null) {
            builder.trustManager(config.trustManagerFactory());
        } else {
            InputStream trustManagerStream = SslContextFactory.supplierNullSafe(config.trustCertChainSupplier());
            try {
                builder.trustManager(trustManagerStream);
            }
            finally {
                BuilderUtils.closeAndRethrowUnchecked(trustManagerStream);
            }
        }
    }

    private static void configureCertificateCompression(SslConfig config, SslContextBuilder builder, @Nullable SslProvider nettySslProvider, boolean forServer) {
        List<CertificateCompressionAlgorithm> algorithms = config.certificateCompressionAlgorithms();
        if (algorithms == null || algorithms.isEmpty()) {
            return;
        }
        if (nettySslProvider == null) {
            nettySslProvider = forServer ? SslContext.defaultServerProvider() : SslContext.defaultClientProvider();
        }
        try {
            if (SSL_PROVIDER_OPTION_SUPPORTED != null ? !SSL_PROVIDER_OPTION_SUPPORTED.invokeExact(nettySslProvider, OpenSslContextOption.CERTIFICATE_COMPRESSION_ALGORITHMS) : nettySslProvider != SslProvider.OPENSSL) {
                return;
            }
        }
        catch (Throwable throwable) {
            ThrowableUtils.throwException(throwable);
        }
        OpenSslCertificateCompressionConfig.Builder configBuilder = OpenSslCertificateCompressionConfig.newBuilder();
        for (CertificateCompressionAlgorithm algorithm : algorithms) {
            if (algorithm.algorithmId() == 1) {
                configBuilder.addAlgorithm(ZlibOpenSslCertificateCompressionAlgorithm.INSTANCE, OpenSslCertificateCompressionConfig.AlgorithmMode.Both);
                continue;
            }
            throw new IllegalArgumentException("Unsupported: " + algorithm);
        }
        builder.option(OpenSslContextOption.CERTIFICATE_COMPRESSION_ALGORITHMS, configBuilder.build());
    }

    @Nullable
    private static <T> T supplierNullSafe(@Nullable Supplier<T> supplier) {
        return supplier == null ? null : (T)supplier.get();
    }

    static {
        MethodHandle sslProviderOptionSupported;
        LOGGER = LoggerFactory.getLogger(SslContextFactory.class);
        try {
            sslProviderOptionSupported = MethodHandles.publicLookup().findStatic(SslProvider.class, "isOptionSupported", MethodType.methodType(Boolean.TYPE, SslProvider.class, SslContextOption.class));
        }
        catch (Throwable cause) {
            LOGGER.debug("SSLProvider#isOptionSupported(SslProvider, SslContextOption) is available only starting from Netty 4.1.88.Final. Detected Netty version: {}", (Object)SslProvider.class.getPackage().getImplementationVersion(), (Object)cause);
            sslProviderOptionSupported = null;
        }
        SSL_PROVIDER_OPTION_SUPPORTED = sslProviderOptionSupported;
    }
}

