/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.EventLoopGroup;
import io.servicetalk.buffer.netty.BufferAllocators;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.transport.api.DefaultExecutionContext;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.netty.internal.EventLoopAwareNettyIoExecutor;
import io.servicetalk.transport.netty.internal.NettyIoExecutors;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlobalExecutionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalExecutionContext.class);

    private GlobalExecutionContext() {
    }

    public static ExecutionContext<ExecutionStrategy> globalExecutionContext() {
        return GlobalExecutionContextInitializer.INSTANCE;
    }

    private static void log(Logger logger, String name, String methodName) {
        logger.info("Closure of \"{}\" was initiated using {} method. Closing the global instance before closing all resources that use it may result in unexpected behavior.", name, methodName, new Throwable("Stack trace"));
    }

    private static final class GlobalIoExecutor
    implements EventLoopAwareNettyIoExecutor {
        private static final Logger LOGGER = LoggerFactory.getLogger(GlobalIoExecutor.class);
        static final String NAME_PREFIX = "servicetalk-global-io-executor";
        private final EventLoopAwareNettyIoExecutor delegate;

        GlobalIoExecutor(EventLoopAwareNettyIoExecutor delegate) {
            this.delegate = delegate;
        }

        @Override
        public Completable closeAsync() {
            return this.delegate.closeAsync().beforeOnSubscribe(__ -> GlobalExecutionContext.log(GlobalIoExecutor.LOGGER, NAME_PREFIX, "closeAsync()"));
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.delegate.closeAsyncGracefully().beforeOnSubscribe(__ -> GlobalExecutionContext.log(GlobalIoExecutor.LOGGER, NAME_PREFIX, "closeAsyncGracefully()"));
        }

        @Override
        public Completable onClose() {
            return this.delegate.onClose();
        }

        @Override
        public Completable onClosing() {
            return this.delegate.onClosing();
        }

        @Override
        public boolean isUnixDomainSocketSupported() {
            return this.delegate.isUnixDomainSocketSupported();
        }

        @Override
        public boolean isFileDescriptorSocketAddressSupported() {
            return this.delegate.isFileDescriptorSocketAddressSupported();
        }

        @Override
        public boolean isIoThreadSupported() {
            return this.delegate.isIoThreadSupported();
        }

        @Override
        public BooleanSupplier shouldOffloadSupplier() {
            return this.delegate.shouldOffloadSupplier();
        }

        @Override
        public boolean isCurrentThreadEventLoop() {
            return this.delegate.isCurrentThreadEventLoop();
        }

        @Override
        public EventLoopGroup eventLoopGroup() {
            return this.delegate.eventLoopGroup();
        }

        @Override
        public EventLoopAwareNettyIoExecutor next() {
            return this.delegate.next();
        }

        @Override
        @Deprecated
        public Executor asExecutor() {
            return this.delegate.asExecutor();
        }

        @Override
        public long currentTime(TimeUnit unit) {
            return this.delegate.currentTime(unit);
        }

        @Override
        public Cancellable execute(Runnable task) throws RejectedExecutionException {
            return this.delegate.execute(task);
        }

        @Override
        public Cancellable schedule(Runnable task, long delay, TimeUnit unit) throws RejectedExecutionException {
            return this.delegate.schedule(task, delay, unit);
        }

        @Override
        public Cancellable schedule(Runnable task, Duration delay) throws RejectedExecutionException {
            return this.delegate.schedule(task, delay);
        }

        @Override
        public Completable timer(long delay, TimeUnit unit) {
            return this.delegate.timer(delay, unit);
        }

        @Override
        public Completable timer(Duration delay) {
            return this.delegate.timer(delay);
        }

        @Override
        public Completable submit(Runnable runnable) {
            return this.delegate.submit(runnable);
        }

        @Override
        public Completable submitRunnable(Supplier<Runnable> runnableSupplier) {
            return this.delegate.submitRunnable(runnableSupplier);
        }

        @Override
        public <T> Single<T> submit(Callable<? extends T> callable) {
            return this.delegate.submit(callable);
        }

        @Override
        public <T> Single<T> submitCallable(Supplier<? extends Callable<? extends T>> callableSupplier) {
            return this.delegate.submitCallable(callableSupplier);
        }
    }

    private static final class GlobalExecutionContextInitializer {
        static final ExecutionContext<ExecutionStrategy> INSTANCE;

        private GlobalExecutionContextInitializer() {
        }

        static {
            GlobalIoExecutor ioExecutor = new GlobalIoExecutor(NettyIoExecutors.createIoExecutor("servicetalk-global-io-executor"));
            Executor executor = Executors.global();
            INSTANCE = new DefaultExecutionContext<ExecutionStrategy>(BufferAllocators.DEFAULT_ALLOCATOR, ioExecutor, executor, ExecutionStrategy.offloadAll());
            LOGGER.debug("Initialized GlobalExecutionContext");
        }
    }
}

