/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.kqueue.KQueue;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ConnectionObserverInitializer
implements ChannelInitializer {
    private final ConnectionObserver observer;
    private final boolean secure;
    private final boolean client;

    public ConnectionObserverInitializer(ConnectionObserver observer, boolean secure, boolean client) {
        this.observer = Objects.requireNonNull(observer);
        this.secure = secure;
        this.client = client;
    }

    @Override
    public void init(Channel channel) {
        channel.closeFuture().addListener(future -> {
            Throwable t = ChannelCloseUtils.channelError(channel);
            if (t == null) {
                this.observer.connectionClosed();
            } else {
                this.observer.connectionClosed(t);
            }
        });
        channel.pipeline().addLast(new ConnectionObserverHandler(this.observer, this.secure, this.isFastOpen(channel)));
    }

    private boolean isFastOpen(Channel channel) {
        return this.client && this.secure && Boolean.TRUE.equals(channel.config().getOption(ChannelOption.TCP_FASTOPEN_CONNECT)) && (Epoll.isTcpFastOpenClientSideAvailable() || KQueue.isTcpFastOpenClientSideAvailable());
    }

    static final class ConnectionObserverHandler
    extends ChannelDuplexHandler {
        private final ConnectionObserver observer;
        private final boolean secure;
        private boolean tcpHandshakeComplete;
        @Nullable
        private ConnectionObserver.SecurityHandshakeObserver handshakeObserver;

        ConnectionObserverHandler(ConnectionObserver observer, boolean secure, boolean fastOpen) {
            this.observer = observer;
            this.secure = secure;
            if (fastOpen) {
                this.reportSecurityHandshakeStarting();
            }
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) {
            if (ctx.channel().isActive()) {
                this.reportTcpHandshakeComplete();
                if (this.secure) {
                    this.reportSecurityHandshakeStarting();
                }
            }
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            this.reportTcpHandshakeComplete();
            if (this.secure) {
                this.reportSecurityHandshakeStarting();
            }
            ctx.fireChannelActive();
        }

        void reportTcpHandshakeComplete() {
            if (!this.tcpHandshakeComplete) {
                this.tcpHandshakeComplete = true;
                this.observer.onTransportHandshakeComplete();
            }
        }

        void reportSecurityHandshakeStarting() {
            if (this.handshakeObserver == null) {
                this.handshakeObserver = this.observer.onSecurityHandshake();
            }
        }

        @Nullable
        ConnectionObserver.SecurityHandshakeObserver handshakeObserver() {
            return this.handshakeObserver;
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof ByteBuf) {
                this.observer.onDataRead(((ByteBuf)msg).readableBytes());
            } else if (msg instanceof ByteBufHolder) {
                this.observer.onDataRead(((ByteBufHolder)msg).content().readableBytes());
            }
            ctx.fireChannelRead(msg);
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            if (msg instanceof ByteBuf) {
                this.observer.onDataWrite(((ByteBuf)msg).readableBytes());
            } else if (msg instanceof ByteBufHolder) {
                this.observer.onDataWrite(((ByteBufHolder)msg).content().readableBytes());
            }
            ctx.write(msg, promise);
        }

        @Override
        public void flush(ChannelHandlerContext ctx) {
            this.observer.onFlush();
            ctx.flush();
        }

        @Override
        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
            this.observer.connectionWritabilityChanged(ctx.channel().isWritable());
            ctx.fireChannelWritabilityChanged();
        }
    }
}

