/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.servicetalk.concurrent.internal.QueueFullException;
import java.util.ArrayDeque;
import java.util.NoSuchElementException;
import java.util.Queue;
import javax.annotation.Nullable;

final class EarlyConnectionAcceptorHandler
extends ChannelInboundHandlerAdapter {
    private final Queue<Runnable> queuedEvents = new ArrayDeque<Runnable>(4);
    private boolean queueingEnabled = true;
    @Nullable
    private ChannelHandlerContext channelHandlerContext;

    EarlyConnectionAcceptorHandler() {
    }

    void releaseEvents() {
        assert (this.channelHandlerContext != null);
        assert (this.channelHandlerContext.channel().eventLoop().inEventLoop());
        if (this.queueingEnabled) {
            Runnable event;
            this.queueingEnabled = false;
            while ((event = this.queuedEvents.poll()) != null) {
                event.run();
            }
            try {
                this.channelHandlerContext.pipeline().remove(this);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    private void enqueueOrRunEvent(Runnable event) {
        if (this.queueingEnabled) {
            if (!this.queuedEvents.offer(event)) {
                throw new QueueFullException(this.getClass().getName() + "#queuedEvents");
            }
        } else {
            event.run();
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.channelHandlerContext = ctx;
        super.handlerAdded(ctx);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.releaseEvents();
        super.handlerRemoved(ctx);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.enqueueOrRunEvent(() -> ctx.fireChannelRead(msg));
        this.releaseEvents();
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) {
        this.enqueueOrRunEvent(ctx::fireChannelRegistered);
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) {
        this.enqueueOrRunEvent(ctx::fireChannelUnregistered);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.enqueueOrRunEvent(ctx::fireChannelActive);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.enqueueOrRunEvent(ctx::fireChannelInactive);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        this.enqueueOrRunEvent(ctx::fireChannelReadComplete);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        this.enqueueOrRunEvent(() -> ctx.fireUserEventTriggered(evt));
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        this.enqueueOrRunEvent(ctx::fireChannelWritabilityChanged);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.enqueueOrRunEvent(() -> ctx.fireExceptionCaught(cause));
    }
}

