/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.TimeSource;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpContextKeys;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.utils.TimeoutFromRequest;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.utils.internal.DurationUtils;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

abstract class AbstractTimeoutHttpFilter
implements HttpExecutionStrategyInfluencer {
    private final BiFunction<HttpRequestMetaData, TimeSource, Duration> timeoutForRequest;
    private final boolean fullRequestResponse;
    @Nullable
    private final Executor timeoutExecutor;

    AbstractTimeoutHttpFilter(TimeoutFromRequest timeoutForRequest, boolean fullRequestResponse) {
        Objects.requireNonNull(timeoutForRequest, "timeoutForRequest");
        this.timeoutForRequest = (request, timeSource) -> timeoutForRequest.apply((HttpRequestMetaData)request);
        this.fullRequestResponse = fullRequestResponse;
        this.timeoutExecutor = null;
    }

    AbstractTimeoutHttpFilter(BiFunction<HttpRequestMetaData, TimeSource, Duration> timeoutForRequest, boolean fullRequestResponse) {
        this.timeoutForRequest = Objects.requireNonNull(timeoutForRequest, "timeoutForRequest");
        this.fullRequestResponse = fullRequestResponse;
        this.timeoutExecutor = null;
    }

    AbstractTimeoutHttpFilter(TimeoutFromRequest timeoutForRequest, boolean fullRequestResponse, Executor timeoutExecutor) {
        Objects.requireNonNull(timeoutForRequest, "timeoutForRequest");
        this.timeoutForRequest = (request, timeSource) -> timeoutForRequest.apply((HttpRequestMetaData)request);
        this.fullRequestResponse = fullRequestResponse;
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor, "timeoutExecutor");
    }

    AbstractTimeoutHttpFilter(BiFunction<HttpRequestMetaData, TimeSource, Duration> timeoutForRequest, boolean fullRequestResponse, Executor timeoutExecutor) {
        this.timeoutForRequest = Objects.requireNonNull(timeoutForRequest, "timeoutForRequest");
        this.fullRequestResponse = fullRequestResponse;
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor, "timeoutExecutor");
    }

    abstract boolean isService();

    @Override
    public final HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }

    final Single<StreamingHttpResponse> withTimeout(StreamingHttpRequest request, Function<StreamingHttpRequest, Single<StreamingHttpResponse>> responseFunction, ExecutionContext<HttpExecutionStrategy> context) {
        return Single.defer(() -> {
            Executor useForTimeout = null != this.timeoutExecutor ? this.timeoutExecutor : this.contextExecutor(request, context);
            Duration timeout = this.timeoutForRequest.apply(request, useForTimeout);
            Single<StreamingHttpResponse> response = (Single<StreamingHttpResponse>)responseFunction.apply(request);
            if (null != timeout) {
                Single<StreamingHttpResponse> timeoutResponse = response.timeout(timeout, useForTimeout);
                if (this.fullRequestResponse) {
                    long deadline = useForTimeout.currentTime(TimeUnit.NANOSECONDS) + timeout.toNanos();
                    response = timeoutResponse.map(resp -> resp.transformMessageBody(body -> Publisher.defer(() -> {
                        Duration remaining = Duration.ofNanos(deadline - useForTimeout.currentTime(TimeUnit.NANOSECONDS));
                        return body.timeoutTerminal(remaining, useForTimeout).onErrorMap(TimeoutException.class, t -> new MappedTimeoutException("message body timeout after " + timeout.toMillis() + "ms", (Throwable)t)).shareContextOnSubscribe();
                    })));
                } else {
                    response = timeoutResponse;
                }
            }
            return response.shareContextOnSubscribe();
        });
    }

    private Executor contextExecutor(HttpRequestMetaData requestMetaData, ExecutionContext<HttpExecutionStrategy> context) {
        if (this.isService()) {
            return context.executionStrategy().isSendOffloaded() ? context.executor() : context.ioExecutor();
        }
        HttpExecutionStrategy strategy = requestMetaData.context().getOrDefault(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, context.executionStrategy());
        assert (strategy != null);
        return strategy.isMetadataReceiveOffloaded() || strategy.isDataReceiveOffloaded() ? context.executor() : context.ioExecutor();
    }

    static final class FixedDuration
    implements BiFunction<HttpRequestMetaData, TimeSource, Duration> {
        private final Duration duration;

        FixedDuration(Duration duration) {
            this.duration = DurationUtils.ensurePositive(duration, "duration");
        }

        @Override
        public Duration apply(HttpRequestMetaData request, TimeSource timeSource) {
            return this.duration;
        }
    }

    private static final class MappedTimeoutException
    extends TimeoutException {
        private static final long serialVersionUID = -8230476062001221272L;

        MappedTimeoutException(String message, Throwable cause) {
            super(message);
            this.initCause(cause);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

