/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.DecoderException;
import io.servicetalk.buffer.netty.BufferUtils;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.internal.SubscribableCompletable;
import io.servicetalk.concurrent.internal.DuplicateSubscribeException;
import io.servicetalk.concurrent.internal.RejectedSubscribeError;
import io.servicetalk.concurrent.internal.TerminalNotification;
import io.servicetalk.http.api.DefaultHttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequests;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.netty.AbstractStreamingHttpConnection;
import io.servicetalk.http.netty.DefaultBlockingStreamingHttpResponseFactory;
import io.servicetalk.http.netty.DefaultHttpResponseFactory;
import io.servicetalk.http.netty.DefaultStreamingHttpResponseFactory;
import io.servicetalk.http.netty.H1ProtocolConfig;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.HttpDebugUtils;
import io.servicetalk.http.netty.HttpExecutionContextUtils;
import io.servicetalk.http.netty.HttpRequestDecoder;
import io.servicetalk.http.netty.HttpResponseEncoder;
import io.servicetalk.http.netty.ReadOnlyHttpServerConfig;
import io.servicetalk.http.netty.SpliceFlatStreamToMetaSingle;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpServerConfig;
import io.servicetalk.tcp.netty.internal.TcpServerBinder;
import io.servicetalk.tcp.netty.internal.TcpServerChannelInitializer;
import io.servicetalk.transport.api.ConnectionContext;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.EarlyConnectionAcceptor;
import io.servicetalk.transport.api.LateConnectionAcceptor;
import io.servicetalk.transport.api.ServerContext;
import io.servicetalk.transport.api.SslConfig;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.transport.netty.internal.CopyByteBufHandlerChannelInitializer;
import io.servicetalk.transport.netty.internal.DefaultNettyConnection;
import io.servicetalk.transport.netty.internal.FlushStrategies;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import io.servicetalk.transport.netty.internal.FlushStrategyHolder;
import io.servicetalk.transport.netty.internal.InfluencerConnectionAcceptor;
import io.servicetalk.transport.netty.internal.NettyConnection;
import io.servicetalk.transport.netty.internal.NettyConnectionContext;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NettyHttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyHttpServer.class);

    private NettyHttpServer() {
    }

    static Single<HttpServerContext> bind(HttpExecutionContext executionContext, ReadOnlyHttpServerConfig config, SocketAddress address, @Nullable InfluencerConnectionAcceptor connectionAcceptor, StreamingHttpService service, boolean drainRequestPayloadBody, @Nullable EarlyConnectionAcceptor earlyConnectionAcceptor, @Nullable LateConnectionAcceptor lateConnectionAcceptor) {
        if (config.h1Config() == null) {
            return Single.failed(NettyHttpServer.newH1ConfigException());
        }
        ReadOnlyTcpServerConfig tcpServerConfig = config.tcpConfig();
        return TcpServerBinder.bind(address, tcpServerConfig, executionContext, connectionAcceptor, (Channel channel, ConnectionObserver connectionObserver) -> NettyHttpServer.initChannel(channel, executionContext, config, new TcpServerChannelInitializer(tcpServerConfig, (ConnectionObserver)connectionObserver), service, drainRequestPayloadBody, connectionObserver), serverConnection -> serverConnection.process(true), earlyConnectionAcceptor, lateConnectionAcceptor).map(delegate -> {
            LOGGER.debug("Started HTTP/1.1 server for address {}.", (Object)delegate.listenAddress());
            return new NettyHttpServerContext((ServerContext)delegate, service, executionContext);
        });
    }

    private static Throwable newH1ConfigException() {
        return new IllegalStateException("HTTP/1.x channel initialization failure due to missing HTTP/1.x configuration");
    }

    static Single<NettyHttpServerConnection> initChannel(Channel channel, HttpExecutionContext builderExecutionContext, ReadOnlyHttpServerConfig config, ChannelInitializer initializer, StreamingHttpService service, boolean drainRequestPayloadBody, ConnectionObserver observer) {
        return NettyHttpServer.initChannel(channel, builderExecutionContext, config, initializer, service, drainRequestPayloadBody, observer, CloseHandler.forPipelinedRequestResponse(false, channel.config()));
    }

    private static Single<NettyHttpServerConnection> initChannel(Channel channel, HttpExecutionContext builderExecutionContext, ReadOnlyHttpServerConfig config, ChannelInitializer initializer, StreamingHttpService service, boolean drainRequestPayloadBody, ConnectionObserver observer, CloseHandler closeHandler) {
        H1ProtocolConfig h1Config = config.h1Config();
        if (h1Config == null) {
            return Single.failed(NettyHttpServer.newH1ConfigException());
        }
        ReadOnlyTcpServerConfig tcpConfig = config.tcpConfig();
        return HttpDebugUtils.showPipeline(DefaultNettyConnection.initChannel(channel, HttpExecutionContextUtils.channelExecutionContext(channel, builderExecutionContext), closeHandler, tcpConfig.flushStrategy(), tcpConfig.idleTimeoutMs(), tcpConfig.sslConfig(), initializer.andThen(NettyHttpServer.getChannelInitializer(BufferUtils.getByteBufAllocator(builderExecutionContext.bufferAllocator()), h1Config, closeHandler)), HttpProtocolVersion.HTTP_1_1, observer, false, __ -> false).map(conn -> new NettyHttpServerConnection((NettyConnection<Object, Object>)conn, service, HttpProtocolVersion.HTTP_1_1, h1Config.headersFactory(), drainRequestPayloadBody, config.allowDropTrailersReadFromTransport())), HttpProtocolVersion.HTTP_1_1, channel);
    }

    private static ChannelInitializer getChannelInitializer(ByteBufAllocator alloc, H1ProtocolConfig config, CloseHandler closeHandler) {
        return new CopyByteBufHandlerChannelInitializer(alloc).andThen(channel -> {
            ArrayDeque<HttpRequestMethod> methodQueue = new ArrayDeque<HttpRequestMethod>(2);
            ChannelPipeline pipeline = channel.pipeline();
            HttpRequestDecoder decoder = new HttpRequestDecoder(methodQueue, alloc, config.headersFactory(), config.maxStartLineLength(), config.maxHeaderFieldLength(), config.specExceptions().allowPrematureClosureBeforePayloadBody(), config.specExceptions().allowLFWithoutCR(), closeHandler);
            pipeline.addLast(decoder);
            pipeline.addLast(new HttpResponseEncoder(methodQueue, config.headersEncodedSizeEstimate(), config.trailersEncodedSizeEstimate(), closeHandler, decoder));
        });
    }

    private static final class ChangingFlushStrategy
    implements FlushStrategy {
        private static final AtomicReferenceFieldUpdater<ChangingFlushStrategy, ChangingWriteEventsListener> listenerUpdater = AtomicReferenceFieldUpdater.newUpdater(ChangingFlushStrategy.class, ChangingWriteEventsListener.class, "listener");
        @Nullable
        private volatile ChangingWriteEventsListener listener;
        private final FlushStrategyHolder flushStrategyHolder;

        private ChangingFlushStrategy(FlushStrategyHolder flushStrategyHolder) {
            this.flushStrategyHolder = flushStrategyHolder;
        }

        Cancellable updateFlushStrategy(NettyConnectionContext.FlushStrategyProvider strategyProvider) {
            return this.flushStrategyHolder.updateFlushStrategy(strategyProvider);
        }

        @Override
        public FlushStrategy.WriteEventsListener apply(FlushStrategy.FlushSender sender) {
            ChangingWriteEventsListener cListener = this.listener;
            if (cListener != null) {
                return cListener;
            }
            ChangingWriteEventsListener l = listenerUpdater.updateAndGet(this, existing -> existing != null ? existing : new ChangingWriteEventsListener(sender, this.flushStrategyHolder));
            assert (l != null);
            return l;
        }

        @Override
        public boolean shouldFlushOnUnwritable() {
            return this.flushStrategyHolder.currentStrategy().shouldFlushOnUnwritable();
        }

        private static final class ChangingWriteEventsListener
        implements FlushStrategy.WriteEventsListener {
            private final FlushStrategy.FlushSender sender;
            private final FlushStrategyHolder flushStrategyHolder;
            private final FlushStrategy defaultStrategy;
            private final FlushStrategy.WriteEventsListener defaultListener;
            private FlushStrategy.WriteEventsListener delegate;
            private boolean firstWrite = true;

            ChangingWriteEventsListener(FlushStrategy.FlushSender sender, FlushStrategyHolder flushStrategyHolder) {
                this.sender = sender;
                this.flushStrategyHolder = flushStrategyHolder;
                this.defaultStrategy = flushStrategyHolder.currentStrategy();
                this.delegate = this.defaultListener = this.defaultStrategy.apply(sender);
            }

            @Override
            public void writeStarted() {
                this.firstWrite = true;
                this.delegate = this.defaultListener;
            }

            @Override
            public void itemWritten(@Nullable Object written) {
                if (this.firstWrite) {
                    FlushStrategy currentStrategy = this.flushStrategyHolder.currentStrategy();
                    if (currentStrategy != this.defaultStrategy) {
                        this.delegate = currentStrategy.apply(this.sender);
                    }
                    this.delegate.writeStarted();
                    this.firstWrite = false;
                }
                this.delegate.itemWritten(written);
            }

            @Override
            public void writeTerminated() {
                this.delegate.writeTerminated();
            }

            @Override
            public void writeCancelled() {
                this.delegate.writeCancelled();
            }
        }
    }

    private static final class ErrorLoggingHttpSubscriber
    implements CompletableSource.Subscriber {
        private static final Logger LOGGER = LoggerFactory.getLogger(ErrorLoggingHttpSubscriber.class);
        private final NettyHttpServerConnection connection;

        ErrorLoggingHttpSubscriber(NettyHttpServerConnection connection) {
            this.connection = connection;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
        }

        @Override
        public void onComplete() {
        }

        @Override
        public void onError(Throwable t) {
            if (t instanceof CloseHandler.CloseEventObservedException) {
                CloseHandler.CloseEventObservedException ceoe = (CloseHandler.CloseEventObservedException)t;
                if (ceoe.event() == CloseHandler.CloseEvent.CHANNEL_CLOSED_INBOUND && t.getCause() instanceof ClosedChannelException) {
                    LOGGER.trace("{} Client closed the {} connection without sending {}.", this.connection, this.connection.protocol(), HttpProtocolVersion.HTTP_2_0.equals(this.connection.protocol()) ? "GO_AWAY" : "'Connection: close' header", t);
                } else if (t.getCause() instanceof DecoderException) {
                    ErrorLoggingHttpSubscriber.logDecoderException((DecoderException)t.getCause(), this.connection);
                } else {
                    ErrorLoggingHttpSubscriber.logUnexpectedException(t.getCause() instanceof IOException ? t.getCause() : t, this.connection);
                }
            } else if (t instanceof DecoderException) {
                ErrorLoggingHttpSubscriber.logDecoderException((DecoderException)t, this.connection);
            } else {
                ErrorLoggingHttpSubscriber.logUnexpectedException(t, this.connection);
            }
        }

        private static void logDecoderException(DecoderException e, NettyHttpServerConnection connection) {
            String whatClosing = HttpProtocolVersion.HTTP_2_0.compareTo(connection.protocol()) <= 0 ? "stream" : "connection";
            boolean isOpen = connection.nettyChannel().isOpen();
            String closeStatement = isOpen ? ", closing it" : "";
            LOGGER.warn("{} Can not decode a message, no more requests will be received on this {} {}{} due to:", connection, connection.protocol(), whatClosing, closeStatement, e);
            if (isOpen) {
                ChannelCloseUtils.close(connection.nettyChannel(), (Throwable)e);
            }
        }

        private static void logUnexpectedException(Throwable t, NettyHttpServerConnection connection) {
            String whatClosing = HttpProtocolVersion.HTTP_2_0.compareTo(connection.protocol()) <= 0 ? "stream" : "connection";
            LOGGER.debug("{} Unexpected error received, closing {} {} due to:", connection, connection.protocol(), whatClosing, t);
            if (connection.nettyChannel().isOpen()) {
                ChannelCloseUtils.close(connection.nettyChannel(), t);
            }
        }
    }

    private static final class SingleSubscriberProcessor
    extends SubscribableCompletable
    implements CompletableSource.Processor,
    Cancellable {
        private static final Object CANCELLED = new Object();
        private static final AtomicReferenceFieldUpdater<SingleSubscriberProcessor, Object> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(SingleSubscriberProcessor.class, Object.class, "state");
        @Nullable
        private volatile Object state;

        private SingleSubscriberProcessor() {
        }

        @Override
        protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
            Object cState;
            subscriber.onSubscribe(this);
            do {
                if ((cState = this.state) instanceof TerminalNotification) {
                    TerminalNotification terminalNotification = (TerminalNotification)cState;
                    terminalNotification.terminate(subscriber);
                } else {
                    if (!(cState instanceof CompletableSource.Subscriber)) continue;
                    subscriber.onError(new DuplicateSubscribeException(cState, subscriber));
                }
                break;
            } while (cState != CANCELLED && (cState != null || !stateUpdater.compareAndSet(this, null, subscriber)));
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
        }

        @Override
        public void onComplete() {
            Object oldState = stateUpdater.getAndSet(this, TerminalNotification.complete());
            if (oldState instanceof CompletableSource.Subscriber) {
                ((CompletableSource.Subscriber)oldState).onComplete();
            }
        }

        @Override
        public void onError(Throwable t) {
            Object oldState = stateUpdater.getAndSet(this, TerminalNotification.error(t));
            if (oldState instanceof CompletableSource.Subscriber) {
                ((CompletableSource.Subscriber)oldState).onError(t);
            }
        }

        @Override
        public void cancel() {
            this.state = CANCELLED;
        }
    }

    static final class NettyHttpServerConnection
    extends HttpServiceContext
    implements NettyConnectionContext {
        private final StreamingHttpService service;
        private final NettyConnection<Object, Object> connection;
        private final HttpHeadersFactory headersFactory;
        private final HttpExecutionContext executionContext;
        private final ChangingFlushStrategy flushStrategy;
        private final boolean drainRequestPayloadBody;
        private final boolean requireTrailerHeader;

        NettyHttpServerConnection(NettyConnection<Object, Object> connection, StreamingHttpService service, HttpProtocolVersion version, HttpHeadersFactory headersFactory, boolean drainRequestPayloadBody, boolean requireTrailerHeader) {
            super(headersFactory, new DefaultHttpResponseFactory(headersFactory, connection.executionContext().bufferAllocator(), version), new DefaultStreamingHttpResponseFactory(headersFactory, connection.executionContext().bufferAllocator(), version), new DefaultBlockingStreamingHttpResponseFactory(headersFactory, connection.executionContext().bufferAllocator(), version));
            this.connection = connection;
            this.headersFactory = headersFactory;
            this.executionContext = new DefaultHttpExecutionContext(connection.executionContext().bufferAllocator(), connection.executionContext().ioExecutor(), connection.executionContext().executor(), HttpExecutionStrategies.offloadNone());
            this.service = service;
            this.flushStrategy = new ChangingFlushStrategy(new FlushStrategyHolder(connection.defaultFlushStrategy()));
            connection.updateFlushStrategy((current, isCurrentOriginal) -> this.flushStrategy);
            this.drainRequestPayloadBody = drainRequestPayloadBody;
            this.requireTrailerHeader = requireTrailerHeader;
        }

        void process(boolean handleMultipleRequests) {
            Single<StreamingHttpRequest> requestSingle = this.connection.read().liftSyncToSingle(new SpliceFlatStreamToMetaSingle((meta, payload) -> StreamingHttpRequests.newTransportRequest(meta.method(), meta.requestTarget(), meta.version(), meta.headers(), this.executionContext().bufferAllocator(), payload, this.requireTrailerHeader, this.headersFactory)));
            SourceAdapters.toSource(this.handleRequestAndWriteResponse(requestSingle, handleMultipleRequests)).subscribe(new ErrorLoggingHttpSubscriber(this));
        }

        @Override
        public Cancellable updateFlushStrategy(NettyConnectionContext.FlushStrategyProvider strategyProvider) {
            return this.flushStrategy.updateFlushStrategy(strategyProvider);
        }

        @Override
        public FlushStrategy defaultFlushStrategy() {
            return this.connection.defaultFlushStrategy();
        }

        private Completable handleRequestAndWriteResponse(Single<StreamingHttpRequest> requestSingle, boolean handleMultipleRequests) {
            Completable exchange = requestSingle.flatMapCompletable(rawRequest -> {
                final SingleSubscriberProcessor requestCompletion = new SingleSubscriberProcessor();
                AtomicBoolean payloadSubscribed = this.drainRequestPayloadBody ? new AtomicBoolean() : null;
                AtomicBoolean responseSent = HeaderUtils.REQ_EXPECT_CONTINUE.test((HttpRequestMetaData)rawRequest) ? new AtomicBoolean() : null;
                StreamingHttpRequest request = rawRequest.transformMessageBody(payload -> payload.afterSubscriber(() -> {
                    if (this.drainRequestPayloadBody) {
                        payloadSubscribed.set(true);
                    }
                    if (responseSent != null && !responseSent.get()) {
                        Channel channel = this.nettyChannel();
                        if (channel.eventLoop().inEventLoop()) {
                            channel.write(this.streamingResponseFactory().continueResponse());
                        } else {
                            channel.eventLoop().execute(() -> channel.write(this.streamingResponseFactory().continueResponse()));
                        }
                    }
                    return new PublisherSource.Subscriber<Object>(){

                        @Override
                        public void onSubscribe(PublisherSource.Subscription s) {
                        }

                        @Override
                        public void onNext(Object obj) {
                        }

                        @Override
                        public void onError(Throwable t) {
                            if (!drainRequestPayloadBody || !(t instanceof RejectedSubscribeError)) {
                                requestCompletion.onComplete();
                            }
                        }

                        @Override
                        public void onComplete() {
                            requestCompletion.onComplete();
                        }
                    };
                }));
                HttpRequestMethod requestMethod = request.method();
                Completable responseWrite = this.connection.write(this.service.handle(this, request, this.streamingResponseFactory()).flatMapPublisher(response -> {
                    if (responseSent != null) {
                        responseSent.set(true);
                    }
                    Cancellable c = null;
                    FlushStrategy flushStrategy = NettyHttpServerConnection.determineFlushStrategyForApi(response);
                    if (flushStrategy != null) {
                        c = this.updateFlushStrategy((prev, isOriginal) -> isOriginal ? flushStrategy : prev);
                    }
                    Publisher<Object> pub = NettyHttpServerConnection.handleResponse(this.protocol(), requestMethod, response);
                    return (c == null ? pub : pub.beforeFinally(c::cancel)).shareContextOnSubscribe();
                }));
                if (this.drainRequestPayloadBody) {
                    return responseWrite.concat(Completable.defer(() -> (payloadSubscribed.get() ? requestCompletion : request.messageBody().ignoreElements().onErrorComplete()).shareContextOnSubscribe()));
                }
                return responseWrite.concat((Completable)requestCompletion);
            });
            return handleMultipleRequests ? exchange.repeat(__ -> true).ignoreElements() : exchange;
        }

        @Nonnull
        private static Publisher<Object> handleResponse(HttpProtocolVersion protocolVersion, HttpRequestMethod requestMethod, StreamingHttpResponse response) {
            Publisher<Object> flatResponse;
            if (HeaderUtils.canAddResponseContentLength(response, requestMethod)) {
                return HeaderUtils.setResponseContentLength(protocolVersion, response);
            }
            Publisher<Object> messageBody = response.messageBody();
            if (HeaderUtils.emptyMessageBody(response, messageBody)) {
                flatResponse = HeaderUtils.flatEmptyMessage(protocolVersion, response, messageBody, true);
            } else {
                flatResponse = Single.succeeded(response).concatPropagateCancel(messageBody);
                if (HeaderUtils.shouldAppendTrailers(protocolVersion, response)) {
                    flatResponse = flatResponse.scanWith(HeaderUtils::appendTrailersMapper);
                }
            }
            HeaderUtils.addResponseTransferEncodingIfNecessary(response, requestMethod);
            return flatResponse;
        }

        @Nullable
        private static FlushStrategy determineFlushStrategyForApi(HttpResponseMetaData response) {
            return AbstractStreamingHttpConnection.isSafeToAggregateOrEmpty(response) ? FlushStrategies.flushOnEnd() : null;
        }

        @Override
        public SocketAddress localAddress() {
            return this.connection.localAddress();
        }

        @Override
        public SocketAddress remoteAddress() {
            return this.connection.remoteAddress();
        }

        @Override
        @Nullable
        public SslConfig sslConfig() {
            return this.connection.sslConfig();
        }

        @Override
        @Nullable
        public SSLSession sslSession() {
            return this.connection.sslSession();
        }

        @Override
        public HttpExecutionContext executionContext() {
            return this.executionContext;
        }

        @Override
        @Nullable
        public <T> T socketOption(SocketOption<T> option) {
            return this.connection.socketOption(option);
        }

        @Override
        public HttpProtocolVersion protocol() {
            return (HttpProtocolVersion)this.connection.protocol();
        }

        @Override
        @Nullable
        public ConnectionContext parent() {
            return this.connection.parent();
        }

        @Override
        public Single<Throwable> transportError() {
            return this.connection.transportError();
        }

        @Override
        public Completable onClosing() {
            return this.connection.onClosing();
        }

        @Override
        public Completable onClose() {
            return this.connection.onClose();
        }

        @Override
        public Completable closeAsync() {
            return this.connection.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.connection.closeAsyncGracefully();
        }

        @Override
        public Channel nettyChannel() {
            return this.connection.nettyChannel();
        }

        @Override
        public void acceptConnections(boolean accept) {
            assert (this.connection.nettyChannel().parent() != null);
            this.connection.nettyChannel().parent().config().setAutoRead(accept);
        }

        public String toString() {
            return this.connection.toString();
        }
    }

    static final class NettyHttpServerContext
    implements HttpServerContext {
        private final ServerContext delegate;
        private final ListenableAsyncCloseable asyncCloseable;
        private final HttpExecutionContext executionContext;

        NettyHttpServerContext(ServerContext delegate, StreamingHttpService service, HttpExecutionContext executionContext) {
            this.delegate = delegate;
            this.asyncCloseable = AsyncCloseables.toListenableAsyncCloseable(AsyncCloseables.newCompositeCloseable().appendAll(service, delegate));
            this.executionContext = executionContext;
        }

        @Override
        public SocketAddress listenAddress() {
            return this.delegate.listenAddress();
        }

        @Override
        public void acceptConnections(boolean accept) {
            this.delegate.acceptConnections(accept);
        }

        @Override
        public HttpExecutionContext executionContext() {
            return this.executionContext;
        }

        @Override
        public Completable closeAsync() {
            return this.asyncCloseable.closeAsync().whenFinally(() -> LOGGER.debug("Stopped HTTP server for address {}.", (Object)this.listenAddress()));
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.asyncCloseable.closeAsyncGracefully();
        }

        @Override
        public Completable onClose() {
            return this.asyncCloseable.onClose();
        }

        @Override
        public Completable onClosing() {
            return this.asyncCloseable.onClosing();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

