/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.AbstractServiceAdapterHolder;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.DefaultHttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import java.util.Objects;

final class BlockingToStreamingService
extends AbstractServiceAdapterHolder {
    static final HttpExecutionStrategy DEFAULT_STRATEGY = DefaultHttpExecutionStrategy.OFFLOAD_RECEIVE_DATA_STRATEGY;
    private final BlockingHttpService original;

    BlockingToStreamingService(BlockingHttpService original, HttpExecutionStrategy strategy) {
        super(HttpExecutionStrategies.defaultStrategy() == strategy ? DEFAULT_STRATEGY : strategy);
        this.original = Objects.requireNonNull(original);
    }

    @Override
    public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
        return request.toRequest().flatMap(req -> Single.fromCallable(() -> this.original.handle(ctx, (HttpRequest)req, ctx.responseFactory())).map(HttpResponse::toStreamingResponse));
    }

    @Override
    public Completable closeAsync() {
        return Completable.fromCallable(() -> {
            this.original.close();
            return null;
        });
    }

    @Override
    public Completable closeAsyncGracefully() {
        return Completable.fromCallable(() -> {
            this.original.closeGracefully();
            return null;
        });
    }
}

