/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.dns.discovery.netty.DefaultDnsClient;
import io.servicetalk.dns.discovery.netty.DnsClient;
import io.servicetalk.dns.discovery.netty.DnsClientFilterFactory;
import io.servicetalk.dns.discovery.netty.DnsClients;
import io.servicetalk.dns.discovery.netty.DnsResolverAddressTypes;
import io.servicetalk.dns.discovery.netty.DnsServerAddressStreamProvider;
import io.servicetalk.dns.discovery.netty.DnsServiceDiscovererBuilder;
import io.servicetalk.dns.discovery.netty.DnsServiceDiscovererObserver;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.netty.internal.GlobalExecutionContext;
import io.servicetalk.utils.internal.DurationUtils;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@Deprecated
public final class DefaultDnsServiceDiscovererBuilder
implements DnsServiceDiscovererBuilder {
    private final String id;
    @Nullable
    private DnsServerAddressStreamProvider dnsServerAddressStreamProvider;
    private DnsResolverAddressTypes dnsResolverAddressTypes = DnsResolverAddressTypes.systemDefault();
    @Nullable
    private Integer maxUdpPayloadSize;
    @Nullable
    private Integer ndots;
    @Nullable
    private Boolean optResourceEnabled;
    @Nullable
    private IoExecutor ioExecutor;
    @Nullable
    private Duration queryTimeout;
    private int minTTLSeconds = 10;
    private int maxTTLSeconds = (int)TimeUnit.MINUTES.toSeconds(5L);
    private int minTTLCacheSeconds;
    private int maxTTLCacheSeconds;
    private Duration ttlJitter = Duration.ofSeconds(4L);
    private int srvConcurrency = 2048;
    private boolean inactiveEventsOnError;
    private boolean completeOncePreferredResolved = true;
    private boolean srvFilterDuplicateEvents;
    private Duration srvHostNameRepeatInitialDelay = Duration.ofSeconds(10L);
    private Duration srvHostNameRepeatJitter = Duration.ofSeconds(5L);
    @Nullable
    private DnsClientFilterFactory filterFactory;
    @Nullable
    private DnsServiceDiscovererObserver observer;
    private ServiceDiscovererEvent.Status missingRecordStatus = ServiceDiscovererEvent.Status.EXPIRED;

    @Deprecated
    public DefaultDnsServiceDiscovererBuilder() {
        this("undefined");
    }

    DefaultDnsServiceDiscovererBuilder(String id) {
        if (id.isEmpty()) {
            throw new IllegalArgumentException("id can not be empty");
        }
        this.id = id;
    }

    @Deprecated
    public DefaultDnsServiceDiscovererBuilder minTTL(int minTTLSeconds) {
        if (minTTLSeconds <= 0) {
            throw new IllegalArgumentException("minTTLSeconds: " + minTTLSeconds + " (expected > 0)");
        }
        this.minTTLSeconds = minTTLSeconds;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder ttl(int minSeconds, int maxSeconds) {
        this.ttl(minSeconds, maxSeconds, 0, 0);
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder ttl(int minSeconds, int maxSeconds, int minCacheSeconds, int maxCacheSeconds) {
        if (minSeconds <= 0 || maxSeconds < minSeconds) {
            throw new IllegalArgumentException("minSeconds: " + minSeconds + ", maxSeconds: " + maxSeconds + " (expected: 0 < minSeconds <= maxSeconds)");
        }
        if (minCacheSeconds < 0 || maxCacheSeconds < minCacheSeconds) {
            throw new IllegalArgumentException("minCacheSeconds: " + minCacheSeconds + ", maxCacheSeconds: " + maxCacheSeconds + " (expected: 0 <= minCacheSeconds <= maxCacheSeconds)");
        }
        if (minCacheSeconds > minSeconds || maxCacheSeconds > maxSeconds) {
            throw new IllegalArgumentException("minCacheSeconds: " + minCacheSeconds + ", maxCacheSeconds: " + maxCacheSeconds + " (expected: 0 <= minCacheSeconds <= minSeconds(" + minSeconds + ") <= maxCacheSeconds <= maxSeconds(" + maxSeconds + "))");
        }
        this.minTTLSeconds = minSeconds;
        this.maxTTLSeconds = maxSeconds;
        this.minTTLCacheSeconds = minCacheSeconds;
        this.maxTTLCacheSeconds = maxCacheSeconds;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder ttlJitter(Duration ttlJitter) {
        DurationUtils.ensurePositive(ttlJitter, "jitter");
        this.ttlJitter = ttlJitter;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder dnsServerAddressStreamProvider(@Nullable DnsServerAddressStreamProvider dnsServerAddressStreamProvider) {
        this.dnsServerAddressStreamProvider = dnsServerAddressStreamProvider;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder optResourceEnabled(boolean optResourceEnabled) {
        this.optResourceEnabled = optResourceEnabled;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder maxUdpPayloadSize(int maxUdpPayloadSize) {
        if (maxUdpPayloadSize <= 0) {
            throw new IllegalArgumentException("maxUdpPayloadSize: " + maxUdpPayloadSize + " (expected > 0)");
        }
        this.maxUdpPayloadSize = maxUdpPayloadSize;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder ndots(int ndots) {
        this.ndots = ndots;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder queryTimeout(Duration queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder dnsResolverAddressTypes(@Nullable DnsResolverAddressTypes dnsResolverAddressTypes) {
        this.dnsResolverAddressTypes = dnsResolverAddressTypes != null ? dnsResolverAddressTypes : DnsResolverAddressTypes.systemDefault();
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder ioExecutor(IoExecutor ioExecutor) {
        this.ioExecutor = ioExecutor;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder observer(DnsServiceDiscovererObserver observer) {
        this.observer = Objects.requireNonNull(observer);
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder missingRecordStatus(ServiceDiscovererEvent.Status status) {
        if (ServiceDiscovererEvent.Status.AVAILABLE.equals(status)) {
            throw new IllegalArgumentException(ServiceDiscovererEvent.Status.AVAILABLE + " status can not be used as missing records' status.");
        }
        this.missingRecordStatus = Objects.requireNonNull(status);
        return this;
    }

    @Override
    public ServiceDiscoverer<String, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> buildSrvDiscoverer() {
        return DnsClients.asSrvDiscoverer(this.build());
    }

    @Override
    public ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> buildARecordDiscoverer() {
        return DnsClients.asHostAndPortDiscoverer(this.build());
    }

    DefaultDnsServiceDiscovererBuilder inactiveEventsOnError(boolean inactiveEventsOnError) {
        this.inactiveEventsOnError = inactiveEventsOnError;
        return this;
    }

    DefaultDnsServiceDiscovererBuilder srvConcurrency(int srvConcurrency) {
        if (srvConcurrency <= 0) {
            throw new IllegalArgumentException("srvConcurrency: " + srvConcurrency + " (expected >0)");
        }
        this.srvConcurrency = srvConcurrency;
        return this;
    }

    DefaultDnsServiceDiscovererBuilder completeOncePreferredResolved(boolean completeOncePreferredResolved) {
        this.completeOncePreferredResolved = completeOncePreferredResolved;
        return this;
    }

    DefaultDnsServiceDiscovererBuilder srvHostNameRepeatDelay(Duration initialDelay, Duration jitter) {
        this.srvHostNameRepeatInitialDelay = Objects.requireNonNull(initialDelay);
        this.srvHostNameRepeatJitter = Objects.requireNonNull(jitter);
        return this;
    }

    DefaultDnsServiceDiscovererBuilder srvFilterDuplicateEvents(boolean srvFilterDuplicateEvents) {
        this.srvFilterDuplicateEvents = srvFilterDuplicateEvents;
        return this;
    }

    DefaultDnsServiceDiscovererBuilder appendFilter(DnsClientFilterFactory factory) {
        Objects.requireNonNull(factory);
        this.filterFactory = DefaultDnsServiceDiscovererBuilder.appendFilter(this.filterFactory, factory);
        return this;
    }

    private static DnsClientFilterFactory appendFilter(@Nullable DnsClientFilterFactory current, DnsClientFilterFactory next) {
        return current == null ? next : dnsClient -> current.create(next.create(dnsClient));
    }

    DnsClient build() {
        DefaultDnsClient rawClient = new DefaultDnsClient(this.id, this.ioExecutor == null ? GlobalExecutionContext.globalExecutionContext().ioExecutor() : this.ioExecutor, this.minTTLSeconds, this.maxTTLSeconds, this.minTTLCacheSeconds, this.maxTTLCacheSeconds, this.ttlJitter.toNanos(), this.srvConcurrency, this.inactiveEventsOnError, this.completeOncePreferredResolved, this.srvFilterDuplicateEvents, this.srvHostNameRepeatInitialDelay, this.srvHostNameRepeatJitter, this.maxUdpPayloadSize, this.ndots, this.optResourceEnabled, this.queryTimeout, this.dnsResolverAddressTypes, this.dnsServerAddressStreamProvider, this.observer, this.missingRecordStatus);
        return this.filterFactory == null ? rawClient : this.filterFactory.create(rawClient);
    }
}

