/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.data.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.async.ByteArrayFeeder;
import com.fasterxml.jackson.core.async.ByteBufferFeeder;
import com.fasterxml.jackson.core.async.NonBlockingInputFeeder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.data.jackson.ByteArrayJacksonDeserializer;
import io.servicetalk.data.jackson.ByteBufferJacksonDeserializer;
import io.servicetalk.serialization.api.SerializationProvider;
import io.servicetalk.serialization.api.StreamingDeserializer;
import io.servicetalk.serialization.api.StreamingSerializer;
import io.servicetalk.serialization.api.TypeHolder;
import io.servicetalk.utils.internal.PlatformDependent;
import java.io.IOException;
import java.util.Objects;

@Deprecated
public final class JacksonSerializationProvider
implements SerializationProvider {
    private final ObjectMapper mapper;

    public JacksonSerializationProvider() {
        this(new ObjectMapper());
    }

    public JacksonSerializationProvider(ObjectMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public <T> StreamingSerializer getSerializer(Class<T> classToSerialize) {
        ObjectWriter writer = this.mapper.writerFor(classToSerialize);
        return (toSerialize, destination) -> JacksonSerializationProvider.serialize0(writer, toSerialize, destination);
    }

    @Override
    public <T> StreamingSerializer getSerializer(TypeHolder<T> typeToSerialize) {
        ObjectWriter writer = this.mapper.writerFor(this.mapper.constructType(typeToSerialize.type()));
        return (toSerialize, destination) -> JacksonSerializationProvider.serialize0(writer, toSerialize, destination);
    }

    @Override
    public <T> StreamingDeserializer<T> getDeserializer(Class<T> classToDeSerialize) {
        return JacksonSerializationProvider.newDeserializer(this.mapper.readerFor(classToDeSerialize));
    }

    @Override
    public <T> StreamingDeserializer<T> getDeserializer(TypeHolder<T> typeToDeserialize) {
        return JacksonSerializationProvider.newDeserializer(this.mapper.readerFor(this.mapper.constructType(typeToDeserialize.type())));
    }

    @Override
    public <T> void serialize(T toSerialize, Buffer destination) {
        JacksonSerializationProvider.serialize0(this.mapper.writerFor(toSerialize.getClass()), toSerialize, destination);
    }

    private static void serialize0(ObjectWriter writer, Object toSerialize, Buffer destination) {
        try {
            writer.writeValue(Buffer.asOutputStream(destination), toSerialize);
        }
        catch (IOException e) {
            PlatformDependent.throwException(e);
        }
    }

    private static <T> StreamingDeserializer<T> newDeserializer(ObjectReader reader) {
        JsonParser parser;
        JsonFactory factory = reader.getFactory();
        try {
            parser = factory.createNonBlockingByteArrayParser();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("parser initialization error for factory: " + factory, e);
        }
        NonBlockingInputFeeder rawFeeder = parser.getNonBlockingInputFeeder();
        if (rawFeeder instanceof ByteBufferFeeder) {
            return new ByteBufferJacksonDeserializer(reader, parser, (ByteBufferFeeder)rawFeeder);
        }
        if (rawFeeder instanceof ByteArrayFeeder) {
            return new ByteArrayJacksonDeserializer(reader, parser, (ByteArrayFeeder)rawFeeder);
        }
        throw new IllegalArgumentException("unsupported feeder type: " + rawFeeder);
    }
}

