/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.database.config;

import io.sermant.database.config.DatabaseWriteProhibitionConfig;
import java.util.Collections;
import java.util.Set;

public class DatabaseWriteProhibitionManager {
    private static DatabaseWriteProhibitionConfig globalConfig = new DatabaseWriteProhibitionConfig();
    private static DatabaseWriteProhibitionConfig localConfig = new DatabaseWriteProhibitionConfig();

    private DatabaseWriteProhibitionManager() {
    }

    public static Set<String> getMongoDbProhibitionDatabases() {
        if (globalConfig.isEnableMongoDbWriteProhibition()) {
            return globalConfig.getMongoDbDatabases();
        }
        if (localConfig.isEnableMongoDbWriteProhibition()) {
            return localConfig.getMongoDbDatabases();
        }
        return Collections.EMPTY_SET;
    }

    public static Set<String> getMySqlProhibitionDatabases() {
        if (globalConfig.isEnableMySqlWriteProhibition()) {
            return globalConfig.getMySqlDatabases();
        }
        if (localConfig.isEnableMySqlWriteProhibition()) {
            return localConfig.getMySqlDatabases();
        }
        return Collections.EMPTY_SET;
    }

    public static Set<String> getPostgreSqlProhibitionDatabases() {
        if (globalConfig.isEnablePostgreSqlWriteProhibition()) {
            return globalConfig.getPostgreSqlDatabases();
        }
        if (localConfig.isEnablePostgreSqlWriteProhibition()) {
            return localConfig.getPostgreSqlDatabases();
        }
        return Collections.EMPTY_SET;
    }

    public static Set<String> getOpenGaussProhibitionDatabases() {
        if (globalConfig.isEnableOpenGaussWriteProhibition()) {
            return globalConfig.getOpenGaussDatabases();
        }
        if (localConfig.isEnableOpenGaussWriteProhibition()) {
            return localConfig.getOpenGaussDatabases();
        }
        return Collections.EMPTY_SET;
    }

    public static DatabaseWriteProhibitionConfig getGlobalConfig() {
        return globalConfig;
    }

    public static DatabaseWriteProhibitionConfig getLocalConfig() {
        return localConfig;
    }

    public static void updateGlobalConfig(DatabaseWriteProhibitionConfig config) {
        if (config == null) {
            globalConfig = new DatabaseWriteProhibitionConfig();
            return;
        }
        globalConfig = config;
    }

    public static void updateLocalConfig(DatabaseWriteProhibitionConfig config) {
        if (config == null) {
            localConfig = new DatabaseWriteProhibitionConfig();
            return;
        }
        localConfig = config;
    }

    public static String printConfig() {
        return "Global WriteProhibitionConfig: " + globalConfig.toString() + "; Local WriteProhibitionConfig: " + localConfig.toString();
    }
}

