/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.postgresqlv42.utils;

import io.sermant.core.plugin.agent.declarer.InterceptDeclarer;
import io.sermant.core.plugin.agent.interceptor.Interceptor;
import io.sermant.core.plugin.agent.matcher.ClassMatcher;
import io.sermant.core.plugin.agent.matcher.MethodMatcher;
import io.sermant.database.handler.DatabaseHandler;
import io.sermant.postgresqlv42.interceptors.PgStatementInterceptor;
import io.sermant.postgresqlv42.interceptors.QueryExecutorImplInterceptor;
import net.bytebuddy.matcher.ElementMatcher;

public class PostgresqlEnhancementHelper {
    private static final String SEND_ONE_QUERY_METHOD_NAME = "sendOneQuery";
    private static final String ENHANCE_CLASS_NAME = "org.postgresql.core.v3.QueryExecutorImpl";
    private static final String INT_CLASS_NAME = "int";
    private static final String SIMPLE_QUERY_CLASS_NAME = "org.postgresql.core.v3.SimpleQuery";
    private static final String SIMPLE_PARAMETER_LIST_CLASS_NAME = "org.postgresql.core.v3.SimpleParameterList";
    private static final String EXECUTE_METHOD_NAME = "execute";
    private static final String EXECUTE_BATCH_METHOD_NAME = "executeBatch";
    private static final String PG_STATEMENT_CLASS_NAME = "org.postgresql.jdbc.PgStatement";
    private static final String QUERY_CLASS_NAME = "org.postgresql.core.Query";
    private static final String PARAMETER_LIST_CLASS_NAME = "org.postgresql.core.ParameterList";
    private static final String[] STATEMENT_EXECUTE_METHOD_PARAMS_TYPE = new String[]{"org.postgresql.core.Query", "org.postgresql.core.ParameterList", "int"};
    private static final String[] EXECUTE_METHOD_PARAMS_TYPE = new String[]{"org.postgresql.core.v3.SimpleQuery", "org.postgresql.core.v3.SimpleParameterList", "int", "int", "int"};

    private PostgresqlEnhancementHelper() {
    }

    private static MethodMatcher getSendOneQueryMethodMatcher() {
        return MethodMatcher.nameEquals((String)SEND_ONE_QUERY_METHOD_NAME).and((ElementMatcher)MethodMatcher.paramTypesEqual((String[])EXECUTE_METHOD_PARAMS_TYPE));
    }

    public static InterceptDeclarer getSendOneQueryInterceptDeclarer(DatabaseHandler handler) {
        return InterceptDeclarer.build((MethodMatcher)PostgresqlEnhancementHelper.getSendOneQueryMethodMatcher(), (Interceptor[])new Interceptor[]{new QueryExecutorImplInterceptor(handler)});
    }

    public static InterceptDeclarer getSendOneQueryInterceptDeclarer() {
        return InterceptDeclarer.build((MethodMatcher)PostgresqlEnhancementHelper.getSendOneQueryMethodMatcher(), (Interceptor[])new Interceptor[]{new QueryExecutorImplInterceptor()});
    }

    public static ClassMatcher getQueryExecutorImplClassMatcher() {
        return ClassMatcher.nameEquals((String)ENHANCE_CLASS_NAME);
    }

    private static MethodMatcher getExecuteMethodMatcher() {
        return MethodMatcher.nameEquals((String)EXECUTE_METHOD_NAME).and((ElementMatcher)MethodMatcher.paramTypesEqual((String[])STATEMENT_EXECUTE_METHOD_PARAMS_TYPE));
    }

    private static MethodMatcher getExecuteBatchMethodMatcher() {
        return MethodMatcher.nameEquals((String)EXECUTE_BATCH_METHOD_NAME);
    }

    public static ClassMatcher getPgStatementClassMatcher() {
        return ClassMatcher.nameEquals((String)PG_STATEMENT_CLASS_NAME);
    }

    public static InterceptDeclarer getPgStatementExecuteInterceptDeclarer() {
        return InterceptDeclarer.build((MethodMatcher)PostgresqlEnhancementHelper.getExecuteMethodMatcher(), (Interceptor[])new Interceptor[]{new PgStatementInterceptor()});
    }

    public static InterceptDeclarer getPgStatementExecuteInterceptDeclarer(DatabaseHandler handler) {
        return InterceptDeclarer.build((MethodMatcher)PostgresqlEnhancementHelper.getExecuteMethodMatcher(), (Interceptor[])new Interceptor[]{new PgStatementInterceptor(handler)});
    }

    public static InterceptDeclarer getPgStatementExecuteBatchInterceptDeclarer() {
        return InterceptDeclarer.build((MethodMatcher)PostgresqlEnhancementHelper.getExecuteBatchMethodMatcher(), (Interceptor[])new Interceptor[]{new PgStatementInterceptor()});
    }

    public static InterceptDeclarer getPgStatementExecuteBatchInterceptDeclarer(DatabaseHandler handler) {
        return InterceptDeclarer.build((MethodMatcher)PostgresqlEnhancementHelper.getExecuteBatchMethodMatcher(), (Interceptor[])new Interceptor[]{new PgStatementInterceptor(handler)});
    }
}

