/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.postgresqlv42.interceptors;

import io.sermant.core.common.LoggerFactory;
import io.sermant.core.plugin.agent.entity.ExecuteContext;
import io.sermant.core.utils.StringUtils;
import io.sermant.database.config.DatabaseWriteProhibitionManager;
import io.sermant.database.constant.DatabaseType;
import io.sermant.database.entity.DatabaseInfo;
import io.sermant.database.handler.DatabaseHandler;
import io.sermant.database.interceptor.AbstractDatabaseInterceptor;
import io.sermant.database.utils.ThreadDatabaseUrlUtil;
import java.util.Properties;
import java.util.logging.Logger;
import org.postgresql.Driver;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Query;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.v3.QueryExecutorImpl;
import org.postgresql.util.HostSpec;

public class QueryExecutorImplInterceptor
extends AbstractDatabaseInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger();
    private static final String GET_DATABASE_METHOD_NAME = "getDatabase";
    private static final String GET_GAUSSDB_VERSION_METHOD_NAME = "getGaussdbVersion";
    private boolean isHighVersion;
    private boolean isGaussdbDatabase;

    public QueryExecutorImplInterceptor() {
        try {
            QueryExecutor.class.getDeclaredMethod(GET_DATABASE_METHOD_NAME, new Class[0]);
            this.isHighVersion = true;
        }
        catch (NoSuchMethodException e) {
            LOGGER.fine("The current database is Postgresql, and the JDBC version is below 9.4.1210.");
        }
        try {
            QueryExecutor.class.getDeclaredMethod(GET_GAUSSDB_VERSION_METHOD_NAME, new Class[0]);
            this.isGaussdbDatabase = true;
        }
        catch (NoSuchMethodException e) {
            LOGGER.fine("The current database is Postgresql, QueryExecutor class does not have the getGaussdbVersion method");
        }
    }

    public QueryExecutorImplInterceptor(DatabaseHandler handler) {
        this.handler = handler;
    }

    @Override
    public ExecuteContext doBefore(ExecuteContext context) {
        DatabaseInfo databaseInfo = this.getDataBaseInfo(context);
        String database = databaseInfo.getDatabaseName();
        Query query = (Query)context.getArguments()[0];
        String sql = query.toString((ParameterList)context.getArguments()[1]);
        if (this.isGaussdbDatabase) {
            this.handleWriteOperationIfWriteDisabled(sql, database, DatabaseWriteProhibitionManager.getOpenGaussProhibitionDatabases(), context);
            return context;
        }
        this.handleWriteOperationIfWriteDisabled(sql, database, DatabaseWriteProhibitionManager.getPostgreSqlProhibitionDatabases(), context);
        return context;
    }

    @Override
    protected void createAndCacheDatabaseInfo(ExecuteContext context) {
        QueryExecutorImpl queryExecutor = (QueryExecutorImpl)context.getObject();
        DatabaseInfo databaseInfo = this.isGaussdbDatabase ? new DatabaseInfo(DatabaseType.OPENGAUSS) : new DatabaseInfo(DatabaseType.POSTGRESQL);
        context.setLocalFieldValue("databaseInfo", (Object)databaseInfo);
        if (this.isHighVersion) {
            databaseInfo.setDatabaseName(queryExecutor.getDatabase());
            HostSpec hostSpec = queryExecutor.getHostSpec();
            if (hostSpec == null) {
                LOGGER.warning("Unable to obtain the link address of the database.");
                return;
            }
            databaseInfo.setHostAddress(hostSpec.getHost());
            databaseInfo.setPort(hostSpec.getPort());
            return;
        }
        String url = ThreadDatabaseUrlUtil.getDatabaseUrl();
        if (StringUtils.isEmpty((CharSequence)url)) {
            return;
        }
        Properties properties = new Properties();
        properties = Driver.parseURL((String)url, (Properties)properties);
        databaseInfo.setHostAddress(properties.getProperty("PGHOST"));
        databaseInfo.setPort(Integer.parseInt(properties.getProperty("PGPORT")));
        databaseInfo.setDatabaseName(properties.getProperty("PGDBNAME"));
    }
}

