/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.postgresqlv42.interceptors;

import io.sermant.core.common.LoggerFactory;
import io.sermant.core.plugin.agent.entity.ExecuteContext;
import io.sermant.database.handler.DatabaseHandler;
import io.sermant.database.interceptor.AbstractDatabaseInterceptor;
import io.sermant.database.utils.ThreadDatabaseUrlUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgresql.jdbc.PgStatement;

public class PgStatementInterceptor
extends AbstractDatabaseInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger();

    public PgStatementInterceptor() {
    }

    public PgStatementInterceptor(DatabaseHandler handler) {
        this.handler = handler;
    }

    @Override
    public ExecuteContext doBefore(ExecuteContext context) {
        PgStatement statement = (PgStatement)context.getObject();
        try {
            Connection connection = statement.getConnection();
            if (connection != null && connection.getMetaData() != null) {
                ThreadDatabaseUrlUtil.setDatabaseUrl(connection.getMetaData().getURL());
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "can not obtain the database information.", e);
        }
        return context;
    }

    @Override
    protected void createAndCacheDatabaseInfo(ExecuteContext context) {
    }

    @Override
    public ExecuteContext after(ExecuteContext context) throws Exception {
        if (this.handler != null) {
            this.handler.doAfter(context);
            return context;
        }
        ThreadDatabaseUrlUtil.removeDatabaseUrl();
        return context;
    }
}

