/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.mariadbv3.interceptors;

import io.sermant.core.common.LoggerFactory;
import io.sermant.core.plugin.agent.entity.ExecuteContext;
import io.sermant.database.constant.DatabaseType;
import io.sermant.database.entity.DatabaseInfo;
import io.sermant.database.interceptor.AbstractDatabaseInterceptor;
import java.util.logging.Logger;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.client.impl.StandardClient;

public abstract class AbstractMariadbV3Interceptor
extends AbstractDatabaseInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger();

    @Override
    protected void createAndCacheDatabaseInfo(ExecuteContext context) {
        DatabaseInfo info = new DatabaseInfo(DatabaseType.MYSQL);
        context.setLocalFieldValue("databaseInfo", (Object)info);
        StandardClient client = (StandardClient)context.getObject();
        if (client.getContext() != null) {
            info.setDatabaseName(client.getContext().getDatabase());
        } else {
            LOGGER.warning("Failed to obtain database name.");
        }
        HostAddress hostAddress = client.getHostAddress();
        info.setHostAddress(hostAddress.host);
        info.setPort(hostAddress.port);
    }
}

