/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.database.interceptor;

import io.sermant.core.plugin.agent.entity.ExecuteContext;
import io.sermant.core.plugin.agent.interceptor.AbstractInterceptor;
import io.sermant.database.controller.DatabaseController;
import io.sermant.database.entity.DatabaseInfo;
import io.sermant.database.handler.DatabaseHandler;
import io.sermant.database.utils.SqlParserUtils;
import java.util.Set;

public abstract class AbstractDatabaseInterceptor
extends AbstractInterceptor {
    protected static final String DATABASE_INFO = "databaseInfo";
    protected DatabaseHandler handler;

    public ExecuteContext before(ExecuteContext context) throws Exception {
        this.createAndCacheDatabaseInfo(context);
        if (this.handler != null) {
            this.handler.doBefore(context);
            return context;
        }
        return this.doBefore(context);
    }

    public ExecuteContext after(ExecuteContext context) throws Exception {
        if (this.handler != null) {
            this.handler.doAfter(context);
            return context;
        }
        return context;
    }

    public ExecuteContext onThrow(ExecuteContext context) throws Exception {
        if (this.handler != null) {
            this.handler.doOnThrow(context);
            return context;
        }
        return context;
    }

    protected abstract ExecuteContext doBefore(ExecuteContext var1);

    protected abstract void createAndCacheDatabaseInfo(ExecuteContext var1);

    protected DatabaseInfo getDataBaseInfo(ExecuteContext context) {
        return (DatabaseInfo)context.getLocalFieldValue(DATABASE_INFO);
    }

    protected void handleWriteOperationIfWriteDisabled(String sql, String databaseName, Set<String> prohibitionDatabases, ExecuteContext context) {
        if (prohibitionDatabases.contains(databaseName) && SqlParserUtils.isWriteOperation(sql)) {
            DatabaseController.disableDatabaseWriteOperation(databaseName, context);
        }
    }

    protected void handleWriteOperationIfWriteDisabled(String databaseName, Set<String> prohibitionDatabases, ExecuteContext context) {
        if (prohibitionDatabases.contains(databaseName)) {
            DatabaseController.disableDatabaseWriteOperation(databaseName, context);
        }
    }
}

