/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.mariadbv3.utils;

import io.sermant.core.plugin.agent.declarer.InterceptDeclarer;
import io.sermant.core.plugin.agent.interceptor.Interceptor;
import io.sermant.core.plugin.agent.matcher.ClassMatcher;
import io.sermant.core.plugin.agent.matcher.MethodMatcher;
import io.sermant.database.handler.DatabaseHandler;
import io.sermant.mariadbv3.interceptors.ExecutePipelineInterceptor;
import io.sermant.mariadbv3.interceptors.SendQueryInterceptor;

public class MariadbV3EnhancementHelper {
    private static final String REPLAY_CLIENT_CLASS = "org.mariadb.jdbc.client.impl.ReplayClient";
    private static final String STANDARD_CLIENT_CLASS = "org.mariadb.jdbc.client.impl.StandardClient";
    private static final String SEND_QUERY_METHOD_NAME = "sendQuery";
    private static final String EXECUTE_PIPELINE_METHOD_NAME = "executePipeline";

    private MariadbV3EnhancementHelper() {
    }

    public static ClassMatcher getReplayClientClassMatcher() {
        return ClassMatcher.nameEquals((String)REPLAY_CLIENT_CLASS);
    }

    public static ClassMatcher getStandardClientClassMatcher() {
        return ClassMatcher.nameEquals((String)STANDARD_CLIENT_CLASS);
    }

    public static InterceptDeclarer getSendQueryInterceptDeclarer() {
        return InterceptDeclarer.build((MethodMatcher)MariadbV3EnhancementHelper.getSendQueryMethodMatcher(), (Interceptor[])new Interceptor[]{new SendQueryInterceptor()});
    }

    public static InterceptDeclarer getSendQueryInterceptDeclarer(DatabaseHandler handler) {
        return InterceptDeclarer.build((MethodMatcher)MariadbV3EnhancementHelper.getSendQueryMethodMatcher(), (Interceptor[])new Interceptor[]{new SendQueryInterceptor(handler)});
    }

    public static InterceptDeclarer getExecutePipelineInterceptDeclarer() {
        return InterceptDeclarer.build((MethodMatcher)MariadbV3EnhancementHelper.getExecutePipelineMethodMatcher(), (Interceptor[])new Interceptor[]{new ExecutePipelineInterceptor()});
    }

    public static InterceptDeclarer getExecutePipelineInterceptDeclarer(DatabaseHandler handler) {
        return InterceptDeclarer.build((MethodMatcher)MariadbV3EnhancementHelper.getExecutePipelineMethodMatcher(), (Interceptor[])new Interceptor[]{new ExecutePipelineInterceptor(handler)});
    }

    private static MethodMatcher getSendQueryMethodMatcher() {
        return MethodMatcher.nameEquals((String)SEND_QUERY_METHOD_NAME);
    }

    private static MethodMatcher getExecutePipelineMethodMatcher() {
        return MethodMatcher.nameEquals((String)EXECUTE_PIPELINE_METHOD_NAME);
    }
}

