/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.mariadbv3.interceptors;

import io.sermant.core.plugin.agent.entity.ExecuteContext;
import io.sermant.database.config.DatabaseWriteProhibitionManager;
import io.sermant.database.controller.DatabaseController;
import io.sermant.database.handler.DatabaseHandler;
import io.sermant.database.utils.SqlParserUtils;
import io.sermant.mariadbv3.interceptors.AbstractMariadbV3Interceptor;
import org.mariadb.jdbc.message.ClientMessage;

public class ExecutePipelineInterceptor
extends AbstractMariadbV3Interceptor {
    public ExecutePipelineInterceptor() {
    }

    public ExecutePipelineInterceptor(DatabaseHandler handler) {
        this.handler = handler;
    }

    @Override
    protected ExecuteContext doBefore(ExecuteContext context) {
        ClientMessage[] clientMessages;
        String database = this.getDataBaseInfo(context).getDatabaseName();
        if (!DatabaseWriteProhibitionManager.getMySqlProhibitionDatabases().contains(database)) {
            return context;
        }
        for (ClientMessage clientMessage : clientMessages = (ClientMessage[])context.getArguments()[0]) {
            if (!SqlParserUtils.isWriteOperation(clientMessage.description())) continue;
            DatabaseController.disableDatabaseWriteOperation(database, context);
            return context;
        }
        return context;
    }
}

