/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.database.dynamicconfig;

import io.sermant.core.common.LoggerFactory;
import io.sermant.core.config.ConfigManager;
import io.sermant.core.plugin.config.ServiceMeta;
import io.sermant.core.service.dynamicconfig.common.DynamicConfigEvent;
import io.sermant.core.service.dynamicconfig.common.DynamicConfigEventType;
import io.sermant.core.service.dynamicconfig.common.DynamicConfigListener;
import io.sermant.database.config.DatabaseWriteProhibitionConfig;
import io.sermant.database.config.DatabaseWriteProhibitionManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.representer.Representer;

public class DatabaseConfigListener
implements DynamicConfigListener {
    public static final String GLOBAL_CONFIG_KEY = "sermant.database.write.globalConfig";
    public static final String LOCAL_CONFIG_KEY_PREFIX = "sermant.database.write.";
    private static final Logger LOGGER = LoggerFactory.getLogger();
    private final Yaml yaml;

    public DatabaseConfigListener() {
        Representer representer = new Representer(new DumperOptions());
        representer.getPropertyUtils().setSkipMissingProperties(true);
        this.yaml = new Yaml(representer);
    }

    public void process(DynamicConfigEvent event) {
        try {
            if (event.getEventType() == DynamicConfigEventType.DELETE) {
                this.processDeleteEvent(event);
                return;
            }
            this.processInitOrCreateOrUpdateEvent(event);
        }
        catch (YAMLException e) {
            LOGGER.log(Level.SEVERE, "Fail to convert dynamic database-write-prohibition config, {0}", e.getMessage());
        }
    }

    private void processInitOrCreateOrUpdateEvent(DynamicConfigEvent event) {
        if (GLOBAL_CONFIG_KEY.equals(event.getKey())) {
            DatabaseWriteProhibitionManager.updateGlobalConfig((DatabaseWriteProhibitionConfig)this.yaml.loadAs(event.getContent(), DatabaseWriteProhibitionConfig.class));
        }
        if ((LOCAL_CONFIG_KEY_PREFIX + ((ServiceMeta)ConfigManager.getConfig(ServiceMeta.class)).getService()).equals(event.getKey())) {
            DatabaseWriteProhibitionManager.updateLocalConfig((DatabaseWriteProhibitionConfig)this.yaml.loadAs(event.getContent(), DatabaseWriteProhibitionConfig.class));
        }
        if (event.getEventType() == DynamicConfigEventType.INIT) {
            LOGGER.log(Level.INFO, "Init database-write-prohibition config, current config: {0}", DatabaseWriteProhibitionManager.printConfig());
            return;
        }
        LOGGER.log(Level.INFO, "Update database-write-prohibition config, current config: {0}", DatabaseWriteProhibitionManager.printConfig());
    }

    private void processDeleteEvent(DynamicConfigEvent event) {
        if (GLOBAL_CONFIG_KEY.equals(event.getKey())) {
            DatabaseWriteProhibitionManager.updateGlobalConfig((DatabaseWriteProhibitionConfig)new DatabaseWriteProhibitionConfig());
        }
        if ((LOCAL_CONFIG_KEY_PREFIX + ((ServiceMeta)ConfigManager.getConfig(ServiceMeta.class)).getService()).equals(event.getKey())) {
            DatabaseWriteProhibitionManager.updateLocalConfig((DatabaseWriteProhibitionConfig)new DatabaseWriteProhibitionConfig());
        }
        LOGGER.log(Level.INFO, "Delete database-write-prohibition config, current config: {0}", DatabaseWriteProhibitionManager.printConfig());
    }
}

