/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.testservice;

import io.netty.buffer.ByteBuf;
import io.scalecube.services.gateway.GatewaySession;
import io.scalecube.services.gateway.GatewaySessionHandler;
import io.scalecube.services.gateway.ws.GatewayMessage;
import io.scalecube.services.testservice.AuthRegistry;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.context.Context;

public class WebsocketGatewaySessionHandler
implements GatewaySessionHandler<GatewayMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketGatewaySessionHandler.class);
    private final AuthRegistry authRegistry;

    public WebsocketGatewaySessionHandler(AuthRegistry authRegistry) {
        this.authRegistry = authRegistry;
    }

    public Context onRequest(GatewaySession session, ByteBuf byteBuf, Context context) {
        Optional<String> authData = this.authRegistry.getAuth(session.sessionId());
        if (authData.isEmpty()) {
            return context;
        }
        return Context.of((Object)"auth.context", (Object)authData.get());
    }

    public GatewayMessage mapMessage(GatewaySession session, GatewayMessage message, Context context) {
        return GatewayMessage.from((GatewayMessage)message).header("SESSION_ID", (Object)session.sessionId()).build();
    }

    public void onSessionOpen(GatewaySession s) {
        LOGGER.info("Session opened: {}", (Object)s);
    }

    public void onSessionClose(GatewaySession session) {
        LOGGER.info("Session removed: {}", (Object)session);
        this.authRegistry.removeAuth(session.sessionId());
    }
}

