/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.testservice;

import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.gateway.GatewaySession;
import io.scalecube.services.gateway.GatewaySessionHandler;
import io.scalecube.services.testservice.AuthRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.context.Context;

public class SecuredRsGwGatewaySessionHandler
implements GatewaySessionHandler<ServiceMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecuredRsGwGatewaySessionHandler.class);
    private final AuthRegistry authRegistry;

    public SecuredRsGwGatewaySessionHandler(AuthRegistry authRegistry) {
        this.authRegistry = authRegistry;
    }

    public ServiceMessage mapMessage(GatewaySession session, ServiceMessage req, Context context) {
        return ServiceMessage.from((ServiceMessage)req).header("SESSION_ID", (Object)session.sessionId()).build();
    }

    public void onSessionOpen(GatewaySession s) {
        LOGGER.info("Session opened: {}", (Object)s);
    }

    public void onSessionClose(GatewaySession session) {
        LOGGER.info("Session removed: {}", (Object)session);
        this.authRegistry.removeAuth(session.sessionId());
    }
}

