/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.testservice;

import io.scalecube.services.gateway.GatewaySession;
import io.scalecube.services.gateway.GatewaySessionHandler;
import io.scalecube.services.gateway.ws.GatewayMessage;
import io.scalecube.services.testservice.AuthRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuredWsGwGatewaySessionManager
implements GatewaySessionHandler<GatewayMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecuredWsGwGatewaySessionManager.class);
    private final AuthRegistry authRegistry;

    public SecuredWsGwGatewaySessionManager(AuthRegistry authRegistry) {
        this.authRegistry = authRegistry;
    }

    public GatewayMessage mapMessage(GatewaySession session, GatewayMessage req) {
        return GatewayMessage.from((GatewayMessage)req).header("SESSION_ID", (Object)session).build();
    }

    public void onSessionOpen(GatewaySession s) {
        LOGGER.info("Session opened: {}", (Object)s);
    }

    public void onSessionClose(GatewaySession session) {
        LOGGER.info("Session removed: {}", (Object)session);
        this.authRegistry.removeAuth(session.sessionId());
    }
}

