/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.util.ReferenceCountUtil;
import io.scalecube.gateway.core.GatewayMessage;
import io.scalecube.services.exceptions.MessageCodecException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayMessageCodec {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayMessageCodec.class);
    private static final ObjectMapper objectMapper = GatewayMessageCodec.objectMapper();
    private static final MappingJsonFactory jsonFactory = new MappingJsonFactory(objectMapper);

    public ByteBuf encode(GatewayMessage message) throws MessageCodecException {
        ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer();
        try (JsonGenerator generator = jsonFactory.createGenerator((OutputStream)new ByteBufOutputStream(byteBuf), JsonEncoding.UTF8);){
            Object data;
            generator.writeStartObject();
            if (message.qualifier() != null) {
                generator.writeStringField("q", message.qualifier());
            }
            if (message.streamId() != null) {
                generator.writeNumberField("sid", message.streamId().longValue());
            }
            if (message.signal() != null) {
                generator.writeNumberField("sig", message.signal().intValue());
            }
            if (message.inactivity() != null) {
                generator.writeNumberField("i", message.inactivity().intValue());
            }
            if ((data = message.data()) != null) {
                if (data instanceof ByteBuf) {
                    ByteBuf dataBin = (ByteBuf)data;
                    if (dataBin.readableBytes() > 0) {
                        generator.writeFieldName("d");
                        generator.writeRaw(":");
                        generator.flush();
                        byteBuf.writeBytes(dataBin);
                    }
                } else {
                    generator.writeObjectField("d", data);
                }
            }
            generator.writeEndObject();
        }
        catch (Throwable ex) {
            ReferenceCountUtil.safeRelease((Object)byteBuf);
            LOGGER.error("Failed to encode message: {}", (Object)message, (Object)ex);
            throw new MessageCodecException("Failed to encode message", ex);
        }
        return byteBuf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GatewayMessage decode(ByteBuf byteBuf) throws MessageCodecException {
        try (ByteBufInputStream stream = new ByteBufInputStream(byteBuf.slice());){
            JsonParser jp = jsonFactory.createParser((InputStream)stream);
            GatewayMessage.Builder result = GatewayMessage.builder();
            JsonToken current = jp.nextToken();
            if (current != JsonToken.START_OBJECT) {
                LOGGER.error("Root should be object: {}", (Object)byteBuf.toString(Charset.defaultCharset()));
                throw new MessageCodecException("Root should be object", null);
            }
            long dataStart = 0L;
            long dataEnd = 0L;
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = jp.getCurrentName();
                current = jp.nextToken();
                if (current == JsonToken.VALUE_NULL) continue;
                switch (fieldName) {
                    case "q": {
                        result.qualifier(jp.getValueAsString());
                        break;
                    }
                    case "sid": {
                        result.streamId(jp.getValueAsLong());
                        break;
                    }
                    case "sig": {
                        result.signal(jp.getValueAsInt());
                        break;
                    }
                    case "i": {
                        result.inactivity(jp.getValueAsInt());
                        break;
                    }
                    case "d": {
                        dataStart = jp.getTokenLocation().getByteOffset();
                        if (current.isScalarValue()) {
                            if (!current.isNumeric() && !current.isBoolean()) {
                                jp.getValueAsString();
                            }
                        } else if (current.isStructStart()) {
                            jp.skipChildren();
                        }
                        dataEnd = jp.getCurrentLocation().getByteOffset();
                        break;
                    }
                }
            }
            if (dataEnd > dataStart) {
                result.data(byteBuf.slice((int)dataStart, (int)(dataEnd - dataStart)));
            }
            GatewayMessage gatewayMessage = result.build();
            return gatewayMessage;
        }
        catch (Throwable ex) {
            LOGGER.error("Failed to decode message: {}", (Object)byteBuf.toString(Charset.defaultCharset()), (Object)ex);
            throw new MessageCodecException("Failed to decode message", ex);
        }
    }

    private static ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        mapper.registerModule((Module)new JavaTimeModule());
        return mapper;
    }
}

