/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.core;

import io.scalecube.gateway.core.Signal;
import io.scalecube.services.api.ServiceMessage;
import java.util.Objects;

public class GatewayMessage {
    public static final String QUALIFIER_FIELD = "q";
    public static final String STREAM_ID_FIELD = "sid";
    public static final String SIGNAL_FIELD = "sig";
    public static final String DATA_FIELD = "d";
    public static final String INACTIVITY_FIELD = "i";
    private String qualifier;
    private Long streamId;
    private Integer signal;
    private Object data;
    private Integer inactivity;

    public static Builder from(GatewayMessage msg) {
        Builder builder = new Builder();
        builder.qualifier = msg.qualifier();
        builder.streamId = msg.streamId();
        builder.signal = msg.signal();
        builder.inactivity = msg.inactivity();
        builder.data = msg.data();
        return builder;
    }

    public static Builder from(ServiceMessage serviceMessage) {
        Builder builder = new Builder();
        builder.qualifier = serviceMessage.qualifier();
        if (serviceMessage.hasData()) {
            builder.data = serviceMessage.data();
        }
        if (serviceMessage.header(STREAM_ID_FIELD) != null) {
            builder.streamId = Long.parseLong(serviceMessage.header(STREAM_ID_FIELD));
        }
        if (serviceMessage.header(SIGNAL_FIELD) != null) {
            builder.signal = Integer.parseInt(serviceMessage.header(SIGNAL_FIELD));
        }
        if (serviceMessage.header(INACTIVITY_FIELD) != null) {
            builder.inactivity = Integer.parseInt(serviceMessage.header(INACTIVITY_FIELD));
        }
        return builder;
    }

    public static ServiceMessage toServiceMessage(GatewayMessage gatewayMessage) {
        ServiceMessage.Builder builder = ServiceMessage.builder().qualifier(gatewayMessage.qualifier()).data(gatewayMessage.data());
        if (gatewayMessage.streamId() != null) {
            builder.header(STREAM_ID_FIELD, String.valueOf(gatewayMessage.streamId()));
        }
        if (gatewayMessage.signal() != null) {
            builder.header(SIGNAL_FIELD, String.valueOf(gatewayMessage.signal()));
        }
        if (gatewayMessage.inactivity() != null) {
            builder.header(INACTIVITY_FIELD, String.valueOf(gatewayMessage.inactivity()));
        }
        return builder.build();
    }

    public static GatewayMessage toGatewayMessage(ServiceMessage serviceMessage) {
        return GatewayMessage.from(serviceMessage).build();
    }

    GatewayMessage() {
    }

    private GatewayMessage(String qualifier, Long streamId, Integer signal, Object data, Integer inactivity) {
        this.qualifier = qualifier;
        this.streamId = streamId;
        this.signal = signal;
        this.data = data;
        this.inactivity = inactivity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String qualifier() {
        return this.qualifier;
    }

    public Long streamId() {
        return this.streamId;
    }

    public Integer signal() {
        return this.signal;
    }

    public <T> T data() {
        return (T)this.data;
    }

    public Integer inactivity() {
        return this.inactivity;
    }

    public boolean hasSignal(Signal signal) {
        return this.signal != null && this.signal.intValue() == signal.code();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GatewayMessage{");
        sb.append("qualifier='").append(this.qualifier).append('\'');
        sb.append(", streamId=").append(this.streamId);
        sb.append(", signal=").append(this.signal);
        sb.append(", data=").append(this.data);
        sb.append(", inactivity=").append(this.inactivity);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private String qualifier;
        private Long streamId;
        private Integer signal;
        private Object data;
        private Integer inactivity;

        Builder() {
        }

        public Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public Builder streamId(Long streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder signal(Integer signal) {
            this.signal = signal;
            return this;
        }

        public Builder signal(Signal signal) {
            this.signal = signal.code();
            return this;
        }

        public Builder inactivity(Integer inactivity) {
            this.inactivity = inactivity;
            return this;
        }

        public Builder data(Object data) {
            this.data = Objects.requireNonNull(data);
            return this;
        }

        public GatewayMessage build() {
            return new GatewayMessage(this.qualifier, this.streamId, this.signal, this.data, this.inactivity);
        }
    }
}

