/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.examples;

import io.scalecube.config.ConfigRegistry;
import io.scalecube.config.ConfigRegistrySettings;
import io.scalecube.config.StringConfigProperty;
import io.scalecube.config.source.ClassPathConfigSource;
import io.scalecube.config.source.ConfigSource;
import java.nio.file.Path;
import java.util.function.Predicate;

public class PredicateOrderingConfigExample {
    public static void main(String[] args) {
        Predicate<Path> propsPredicate = path -> path.toString().endsWith(".props");
        Predicate<Path> firstPredicate = propsPredicate.and(path -> path.toString().contains("order1"));
        Predicate<Path> secondPredicate = propsPredicate.and(path -> path.toString().contains("order2"));
        ConfigRegistry configRegistry = ConfigRegistry.create((ConfigRegistrySettings)ConfigRegistrySettings.builder().addLastSource("classpath", (ConfigSource)new ClassPathConfigSource(new Predicate[]{firstPredicate, secondPredicate})).build());
        StringConfigProperty orderedProp1 = configRegistry.stringProperty("orderedProp1");
        System.out.println("### Matched by first predicate orderedProp1=" + (String)orderedProp1.value().get());
    }
}

