/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.examples;

import io.scalecube.config.ConfigRegistry;
import io.scalecube.config.ConfigRegistrySettings;
import io.scalecube.config.StringConfigProperty;
import io.scalecube.config.audit.ConfigEventListener;
import io.scalecube.config.audit.Slf4JConfigEventListener;
import io.scalecube.config.keyvalue.KeyValueConfigRepository;
import io.scalecube.config.keyvalue.KeyValueConfigSource;
import io.scalecube.config.mongo.MongoConfigConnector;
import io.scalecube.config.mongo.MongoConfigEventListener;
import io.scalecube.config.mongo.MongoConfigRepository;
import io.scalecube.config.source.ConfigSource;

public class MongoConfigExample {
    public static void main(String[] args) {
        String databaseName = args[0] != null ? args[0] : "MongoConfigExample" + System.currentTimeMillis();
        String uri = "mongodb://localhost:27017/" + databaseName;
        String configSourceCollectionName = "MongoConfigRepository";
        String auditLogCollectionName = "TestConfigurationAuditLog";
        MongoConfigConnector connector = MongoConfigConnector.builder().forUri(uri).build();
        KeyValueConfigSource mongoConfigSource = KeyValueConfigSource.withRepository((KeyValueConfigRepository)new MongoConfigRepository(connector), (String)configSourceCollectionName).groups(new String[]{"group1", "group2", "group3"}).build();
        ConfigRegistry configRegistry = ConfigRegistry.create((ConfigRegistrySettings)ConfigRegistrySettings.builder().addLastSource("MongoConfig", (ConfigSource)mongoConfigSource).addListener((ConfigEventListener)new Slf4JConfigEventListener()).addListener((ConfigEventListener)new MongoConfigEventListener(connector, auditLogCollectionName)).keepRecentConfigEvents(3).reloadIntervalSec(1).build());
        StringConfigProperty prop1 = configRegistry.stringProperty("prop1");
        System.out.println("### Initial mongo config property: prop1=" + (String)prop1.value().get() + ", group=" + (String)prop1.origin().get());
        StringConfigProperty prop2 = configRegistry.stringProperty("prop2");
        System.out.println("### Initial mongo config property: prop2=" + (String)prop2.value().get() + ", group=" + (String)prop2.origin().get());
        StringConfigProperty propRoot = configRegistry.stringProperty("propRoot");
        System.out.println("### Initial mongo config **root** property: propRoot=" + (String)propRoot.value().get() + ", group=" + (String)propRoot.origin().get());
    }
}

