/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.examples;

import io.scalecube.config.ConfigRegistry;
import io.scalecube.config.ConfigRegistrySettings;
import io.scalecube.config.StringConfigProperty;
import io.scalecube.config.audit.ConfigEventListener;
import io.scalecube.config.audit.Slf4JConfigEventListener;
import io.scalecube.config.http.server.ConfigRegistryHttpServer;
import io.scalecube.config.keyvalue.KeyValueConfigRepository;
import io.scalecube.config.keyvalue.KeyValueConfigSource;
import io.scalecube.config.mongo.MongoConfigConnector;
import io.scalecube.config.mongo.MongoConfigEventListener;
import io.scalecube.config.mongo.MongoConfigRepository;
import io.scalecube.config.source.ConfigSource;
import io.scalecube.config.source.DirectoryConfigSource;
import java.nio.file.Path;
import java.util.function.Predicate;

public class DemoConfig {
    public static void main(String[] args) {
        String databaseName = "MongoConfigExample";
        String uri = "mongodb://localhost:27017/" + databaseName;
        String configSourceCollectionName = "MongoConfigRepository";
        String auditLogCollectionName = "TestConfigurationAuditLog";
        MongoConfigConnector connector = MongoConfigConnector.builder().forUri(uri).build();
        KeyValueConfigSource mongoConfigSource = KeyValueConfigSource.withRepository((KeyValueConfigRepository)new MongoConfigRepository(connector), (String)configSourceCollectionName).groups(new String[]{"group2", "group1", "root"}).build();
        Predicate<Path> propsPredicate = path -> path.toString().endsWith(".props");
        String basePath = "config-examples/config";
        ConfigRegistry configRegistry = ConfigRegistry.create((ConfigRegistrySettings)ConfigRegistrySettings.builder().addLastSource("ConfigDirectory", (ConfigSource)new DirectoryConfigSource(basePath, new Predicate[]{propsPredicate})).addLastSource("MongoConfig", (ConfigSource)mongoConfigSource).addListener((ConfigEventListener)new Slf4JConfigEventListener()).addListener((ConfigEventListener)new MongoConfigEventListener(connector, auditLogCollectionName)).keepRecentConfigEvents(10).reloadIntervalSec(3).jmxEnabled(true).jmxMBeanName("config.exporter:name=ConfigRegistry").build());
        SomeComponent component = new SomeComponent(configRegistry);
        ConfigRegistryHttpServer.create((ConfigRegistry)configRegistry, (int)5050);
    }

    static class SomeComponent {
        private StringConfigProperty host;

        SomeComponent(ConfigRegistry cfgReg) {
            this.host = cfgReg.stringProperty("host");
            this.host.addCallback((oldVal, newVal) -> System.out.println("###Property changed: " + oldVal + "->" + newVal));
        }
    }
}

