/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.tcp.loadbalancing;

import io.netty.buffer.ByteBuf;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.client.ConnectionProviderFactory;
import io.reactivex.netty.client.Host;
import io.reactivex.netty.client.loadbalancer.LoadBalancerFactory;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.examples.tcp.loadbalancing.TcpLoadBalancer;
import io.reactivex.netty.protocol.tcp.client.TcpClient;
import io.reactivex.netty.protocol.tcp.server.TcpServer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import rx.Observable;

public final class TcpLoadBalancingClient {
    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(TcpLoadBalancingClient.class);
        Logger logger = env.getLogger();
        Observable hosts = Observable.just((Object)TcpLoadBalancingClient.startNewServer(), (Object)TcpLoadBalancingClient.startNewServer(), (Object)new InetSocketAddress(0)).map(Host::new);
        TcpClient.newClient((ConnectionProviderFactory)LoadBalancerFactory.create(new TcpLoadBalancer()), (Observable)hosts).enableWireLogging("lb-client", LogLevel.DEBUG).createConnectionRequest().doOnNext(conn -> logger.info("Using host: " + conn.unsafeNettyChannel().remoteAddress())).flatMap(connection -> connection.writeString(Observable.just((Object)"Hello World!")).cast(ByteBuf.class).concatWith((Observable)connection.getInput())).take(1).map(bb -> bb.toString(Charset.defaultCharset())).repeat(5L).toBlocking().forEach(arg_0 -> ((Logger)logger).info(arg_0));
    }

    private static SocketAddress startNewServer() {
        return TcpServer.newServer().start(conn -> conn.writeAndFlushOnEach((Observable)conn.getInput())).getServerAddress();
    }
}

