/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.ws.messaging;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.examples.http.ws.messaging.AcceptOnlyBinaryFramesFilter;
import io.reactivex.netty.examples.http.ws.messaging.MessageFrame;
import io.reactivex.netty.protocol.http.server.HttpServer;
import rx.Observable;
import rx.functions.Func1;

public final class MessagingServer {
    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(MessagingServer.class);
        HttpServer server = HttpServer.newServer().enableWireLogging("msg-server", LogLevel.DEBUG).start((req, resp) -> {
            if (req.isWebSocketUpgradeRequested()) {
                return resp.acceptWebSocketUpgrade(wsConn -> {
                    Observable in = wsConn.getInput().filter((Func1)AcceptOnlyBinaryFramesFilter.INSTANCE).cast(BinaryWebSocketFrame.class).map(f -> {
                        ByteBuf data = f.content();
                        data.setByte(data.readerIndex(), 1);
                        return new MessageFrame(data);
                    });
                    return wsConn.writeAndFlushOnEach(in);
                });
            }
            return resp.setStatus(HttpResponseStatus.NOT_FOUND);
        });
        if (env.shouldWaitForShutdown(args)) {
            server.awaitShutdown();
        }
        env.registerServerAddress(server.getServerAddress());
    }
}

