/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.ws.messaging;

import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.examples.http.ws.messaging.AcceptOnlyBinaryFramesFilter;
import io.reactivex.netty.examples.http.ws.messaging.MessageProducer;
import io.reactivex.netty.examples.http.ws.messaging.MessagingServer;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.ws.client.WebSocketResponse;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import rx.Observable;
import rx.functions.Func1;

public final class MessagingClient {
    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(MessagingClient.class);
        SocketAddress socketAddress = env.getServerAddress(MessagingServer.class, args);
        Logger logger = env.getLogger();
        MessageProducer producer = new MessageProducer(10, 1L, TimeUnit.SECONDS);
        HttpClient.newClient((SocketAddress)socketAddress).enableWireLogging("msging-client", LogLevel.DEBUG).createGet("/ws").requestWebSocketUpgrade().doOnNext(resp -> logger.info(resp.toString())).flatMap(WebSocketResponse::getWebSocketConnection).flatMap(conn -> conn.writeAndFlushOnEach(producer.getMessageStream()).cast(WebSocketFrame.class).mergeWith(conn.getInput())).retryWhen(errStream -> errStream.flatMap(err -> {
            if (err instanceof IOException) {
                return Observable.timer((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            return Observable.error((Throwable)err);
        })).filter((Func1)AcceptOnlyBinaryFramesFilter.INSTANCE).cast(BinaryWebSocketFrame.class).map(producer::acceptAcknowledgment).take(10).toBlocking().forEach(msgId -> logger.info("Received acknowledgment for message id => " + msgId.toString()));
    }
}

