/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.ws.echo;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.protocol.http.server.HttpServer;
import rx.Observable;

public final class WebSocketEchoServer {
    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(WebSocketEchoServer.class);
        HttpServer server = HttpServer.newServer().enableWireLogging("ws-server", LogLevel.DEBUG).start((req, resp) -> {
            if (req.isWebSocketUpgradeRequested()) {
                return resp.acceptWebSocketUpgrade(wsConn -> wsConn.writeAndFlushOnEach(wsConn.getInput()));
            }
            if (req.getUri().startsWith("/hello")) {
                return resp.writeString(Observable.just((Object)"Hello World"));
            }
            return resp.setStatus(HttpResponseStatus.NOT_FOUND);
        });
        if (env.shouldWaitForShutdown(args)) {
            server.awaitShutdown();
        }
        env.registerServerAddress(server.getServerAddress());
    }
}

