/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.ws.echo;

import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.examples.http.ws.echo.WebSocketEchoServer;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.ws.client.WebSocketResponse;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import rx.Observable;

public final class WebSocketEchoClient {
    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(WebSocketEchoClient.class);
        SocketAddress socketAddress = env.getServerAddress(WebSocketEchoServer.class, args);
        Logger logger = env.getLogger();
        HttpClient.newClient((SocketAddress)socketAddress).enableWireLogging("ws-echo-client", LogLevel.DEBUG).createGet("/ws").requestWebSocketUpgrade().doOnNext(resp -> logger.info(resp.toString())).flatMap(WebSocketResponse::getWebSocketConnection).flatMap(conn -> conn.write(Observable.range((int)1, (int)10).map(anInt -> new TextWebSocketFrame("Interval " + anInt)).cast(WebSocketFrame.class).concatWith(Observable.just((Object)new CloseWebSocketFrame()))).cast(WebSocketFrame.class).mergeWith(conn.getInput())).take(10).toBlocking().forEach(frame -> logger.info(frame.content().toString(Charset.defaultCharset())));
    }
}

