/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.secure;

import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.protocol.http.client.HttpClient;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;

public final class SecureDefaultHttpClient {
    private static final String HOST = "github.com";
    private static final Integer PORT = 443;

    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(SecureDefaultHttpClient.class);
        Logger logger = env.getLogger();
        SSLEngine sslEngine = null;
        try {
            sslEngine = SecureDefaultHttpClient.defaultSSLEngineForClient();
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error("Failed to create SSLEngine.", (Throwable)nsae);
            System.exit(-1);
        }
        HttpClient.newClient((String)HOST, (int)PORT).enableWireLogging("http-secure-default-client", LogLevel.DEBUG).secure(sslEngine).createGet("/").doOnNext(resp -> logger.info(resp.toString())).flatMap(resp -> {
            System.out.println(resp.getStatus());
            return resp.getContent().map(bb -> bb.toString(Charset.defaultCharset()));
        }).toBlocking().forEach(arg_0 -> ((Logger)logger).info(arg_0));
    }

    private static SSLEngine defaultSSLEngineForClient() throws NoSuchAlgorithmException {
        SSLContext sslCtx = SSLContext.getDefault();
        SSLEngine sslEngine = sslCtx.createSSLEngine(HOST, PORT);
        sslEngine.setUseClientMode(true);
        return sslEngine;
    }
}

