/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.perf;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.protocol.http.server.HttpServer;
import rx.Observable;

public final class PerfHelloWorldServer {
    private static final ByteBuf WELCOME_MSG_BUFFER = Unpooled.buffer().writeBytes("Welcome!!".getBytes());
    private static final Observable<ByteBuf> RESPONSE_CONTENT = Observable.just((Object)WELCOME_MSG_BUFFER).doOnSubscribe(() -> ((ByteBuf)WELCOME_MSG_BUFFER).retain());
    private static final String CONTENT_LENGTH_HEADER_VAL = String.valueOf(WELCOME_MSG_BUFFER.readableBytes());

    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(PerfHelloWorldServer.class);
        HttpServer server = HttpServer.newServer().start((req, resp) -> resp.setHeader((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)CONTENT_LENGTH_HEADER_VAL).flushOnlyOnReadComplete().write(RESPONSE_CONTENT));
        if (env.shouldWaitForShutdown(args)) {
            server.awaitShutdown();
        }
        env.registerServerAddress(server.getServerAddress());
    }
}

