/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.loadbalancing;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.client.ConnectionProviderFactory;
import io.reactivex.netty.client.Host;
import io.reactivex.netty.client.loadbalancer.LoadBalancerFactory;
import io.reactivex.netty.client.loadbalancer.LoadBalancingStrategy;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.loadbalancer.EWMABasedP2CStrategy;
import io.reactivex.netty.protocol.http.server.HttpServer;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import rx.Observable;

public final class HttpLoadBalancingClient {
    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(HttpLoadBalancingClient.class);
        Logger logger = env.getLogger();
        Observable hosts = Observable.just((Object)HttpLoadBalancingClient.startNewServer(HttpResponseStatus.OK), (Object)HttpLoadBalancingClient.startNewServer(HttpResponseStatus.OK), (Object)HttpLoadBalancingClient.startNewServer(HttpResponseStatus.SERVICE_UNAVAILABLE)).map(Host::new);
        HttpClient.newClient((ConnectionProviderFactory)LoadBalancerFactory.create((LoadBalancingStrategy)new EWMABasedP2CStrategy()), (Observable)hosts).enableWireLogging("lb-client", LogLevel.DEBUG).createGet("/hello").doOnNext(resp -> logger.info(resp.toString())).flatMap(resp -> resp.getContent().map(bb -> bb.toString(Charset.defaultCharset()))).repeat(5L).toBlocking().forEach(arg_0 -> ((Logger)logger).info(arg_0));
    }

    private static SocketAddress startNewServer(HttpResponseStatus cannedStatus) {
        return HttpServer.newServer().start((req, resp) -> resp.setStatus(cannedStatus)).getServerAddress();
    }
}

