/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.loadbalancing;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.netty.client.events.ClientEventListener;
import io.reactivex.netty.examples.tcp.loadbalancing.AbstractLoadBalancer;
import io.reactivex.netty.protocol.http.client.events.HttpClientEventsListener;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpLoadBalancer<W, R>
extends AbstractLoadBalancer<W, R> {
    private static final Logger logger = LoggerFactory.getLogger(HttpLoadBalancer.class);

    @Override
    protected ClientEventListener newListener() {
        return new ClientEventListenerImpl();
    }

    @Override
    protected long getWeight(ClientEventListener eventListener) {
        return ((ClientEventListenerImpl)eventListener).weight;
    }

    private static class ClientEventListenerImpl
    extends HttpClientEventsListener {
        private volatile long weight = Long.MAX_VALUE;

        private ClientEventListenerImpl() {
        }

        public void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            this.weight = Long.MIN_VALUE;
        }

        public void onByteRead(long bytesRead) {
            super.onByteRead(bytesRead);
        }

        public void onResponseHeadersReceived(int responseCode, long duration, TimeUnit timeUnit) {
            logger.error("Response code: " + responseCode);
            if (HttpResponseStatus.SERVICE_UNAVAILABLE.code() == responseCode) {
                this.weight = Long.MIN_VALUE;
            }
        }
    }
}

