/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.interceptors.simple;

import io.netty.buffer.ByteBuf;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerInterceptorChain;
import rx.Observable;

public final class InterceptingServer {
    public static final String INTERCEPTOR_HEADER_NAME = "X-from-interceptor";

    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(InterceptingServer.class);
        HttpServer server = HttpServer.newServer().enableWireLogging("inter-server", LogLevel.DEBUG).start(HttpServerInterceptorChain.startRaw().next(InterceptingServer.addHeader()).end((req, resp) -> resp.writeString(Observable.just((Object)"Hello World!"))));
        if (env.shouldWaitForShutdown(args)) {
            server.awaitShutdown();
        }
        env.registerServerAddress(server.getServerAddress());
    }

    private static HttpServerInterceptorChain.Interceptor<ByteBuf, ByteBuf> addHeader() {
        return handler -> (request, response) -> {
            String clientHeader = request.containsHeader((CharSequence)INTERCEPTOR_HEADER_NAME) ? request.getHeader((CharSequence)INTERCEPTOR_HEADER_NAME) : "none";
            return handler.handle(request.addHeader((CharSequence)INTERCEPTOR_HEADER_NAME, (Object)"server"), response.addHeader((CharSequence)INTERCEPTOR_HEADER_NAME, (Object)clientHeader).addHeader((CharSequence)INTERCEPTOR_HEADER_NAME, (Object)"server"));
        };
    }
}

