/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.udp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.protocol.udp.client.UdpClientBuilder;
import java.nio.charset.Charset;
import rx.Observable;
import rx.functions.Func1;

public final class HelloUdpClient {
    private final int port;

    public HelloUdpClient(int port) {
        this.port = port;
    }

    public String sendHello() {
        String content = (String)((UdpClientBuilder)RxNetty.newUdpClientBuilder((String)"localhost", (int)this.port).enableWireLogging(LogLevel.ERROR)).build().connect().flatMap((Func1)new Func1<ObservableConnection<DatagramPacket, DatagramPacket>, Observable<DatagramPacket>>(){

            public Observable<DatagramPacket> call(ObservableConnection<DatagramPacket, DatagramPacket> connection) {
                connection.writeStringAndFlush("Is there anybody out there?");
                return connection.getInput();
            }
        }).take(1).map((Func1)new Func1<DatagramPacket, String>(){

            public String call(DatagramPacket datagramPacket) {
                return ((ByteBuf)datagramPacket.content()).toString(Charset.defaultCharset());
            }
        }).toBlocking().first();
        System.out.println("Received: " + content);
        return content;
    }

    public static void main(String[] args) {
        new HelloUdpClient(8098).sendHello();
    }
}

