/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.tcp.ssl;

import io.reactivex.netty.RxNetty;
import io.reactivex.netty.channel.ConnectionHandler;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.pipeline.PipelineConfigurators;
import io.reactivex.netty.pipeline.ssl.DefaultFactories;
import io.reactivex.netty.server.RxServer;
import io.reactivex.netty.server.ServerBuilder;
import rx.Observable;
import rx.functions.Func1;

public final class SslTcpEchoServer {
    static final int DEFAULT_PORT = 8104;
    private final int port;

    public SslTcpEchoServer(int port) {
        this.port = port;
    }

    public RxServer<String, String> createServer() {
        RxServer server = (RxServer)((ServerBuilder)((ServerBuilder)RxNetty.newTcpServerBuilder((int)this.port, (ConnectionHandler)new ConnectionHandler<String, String>(){

            public Observable<Void> handle(final ObservableConnection<String, String> connection) {
                System.out.println("New client connection established.");
                connection.writeAndFlush((Object)"Welcome! \n\n");
                return connection.getInput().flatMap((Func1)new Func1<String, Observable<Void>>(){

                    public Observable<Void> call(String msg) {
                        System.out.println("onNext: " + msg);
                        msg = msg.trim();
                        if (!msg.isEmpty()) {
                            return connection.writeAndFlush((Object)("echo => " + msg + '\n'));
                        }
                        return Observable.empty();
                    }
                });
            }
        }).withSslEngineFactory(DefaultFactories.selfSigned())).appendPipelineConfigurator(PipelineConfigurators.textOnlyConfigurator())).build();
        System.out.println("TCP echo server started...");
        return server;
    }

    public static void main(String[] args) {
        new SslTcpEchoServer(8104).createServer().startAndWait();
    }
}

