/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.tcp.event;

import io.reactivex.netty.RxNetty;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.pipeline.PipelineConfigurators;
import rx.Observable;
import rx.functions.Func1;

public final class TcpEventStreamClient {
    private final int port;
    private final int delay;
    private final int noOfEvents;

    public TcpEventStreamClient(int port, int delay, int noOfEvents) {
        this.port = port;
        this.delay = delay;
        this.noOfEvents = noOfEvents;
    }

    public int readEvents() {
        Observable connectionObservable = RxNetty.createTcpClient((String)"localhost", (int)this.port, (PipelineConfigurator)PipelineConfigurators.stringMessageConfigurator()).connect();
        Iterable eventIterable = connectionObservable.flatMap(new Func1<ObservableConnection<String, String>, Observable<?>>(){

            public Observable<?> call(ObservableConnection<String, String> connection) {
                return connection.getInput().map((Func1)new Func1<String, String>(){

                    public String call(String msg) {
                        TcpEventStreamClient.this.delayProcessing();
                        return msg.trim();
                    }
                });
            }
        }).take(this.noOfEvents).toBlocking().toIterable();
        int count = 0;
        for (Object e : eventIterable) {
            System.out.println("onNext event => " + e);
            ++count;
        }
        return count;
    }

    private void delayProcessing() {
        if (this.delay > 0) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        int delay = 1000;
        int noOfEvents = 100;
        if (args.length > 1) {
            delay = Integer.valueOf(args[0]);
            noOfEvents = Integer.valueOf(args[1]);
        }
        new TcpEventStreamClient(8100, delay, noOfEvents).readEvents();
    }
}

