/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.tcp.echo;

import io.reactivex.netty.RxNetty;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.pipeline.PipelineConfigurators;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func1;

public final class TcpEchoClient {
    private final int port;

    public TcpEchoClient(int port) {
        this.port = port;
    }

    public List<String> sendEchos() {
        Observable connectionObservable = RxNetty.createTcpClient((String)"localhost", (int)this.port, (PipelineConfigurator)PipelineConfigurators.textOnlyConfigurator()).connect();
        Iterable echos = connectionObservable.flatMap(new Func1<ObservableConnection<String, String>, Observable<?>>(){

            public Observable<?> call(final ObservableConnection<String, String> connection) {
                Observable helloMessage = connection.getInput().take(1).map((Func1)new Func1<String, String>(){

                    public String call(String s) {
                        return s.trim();
                    }
                });
                Observable intervalOutput = Observable.interval((long)500L, (TimeUnit)TimeUnit.MILLISECONDS).flatMap((Func1)new Func1<Long, Observable<String>>(){

                    public Observable<String> call(Long aLong) {
                        return connection.writeAndFlush((Object)String.valueOf(aLong + 1L)).map((Func1)new Func1<Void, String>(){

                            public String call(Void aVoid) {
                                return "";
                            }
                        });
                    }
                });
                Observable echo = connection.getInput().map((Func1)new Func1<String, String>(){

                    public String call(String s) {
                        return s.trim();
                    }
                });
                return Observable.concat((Observable)helloMessage, (Observable)Observable.merge((Observable)intervalOutput, (Observable)echo));
            }
        }).take(10).doOnCompleted(new Action0(){

            public void call() {
                System.out.println("COMPLETED!");
            }
        }).toBlocking().toIterable();
        ArrayList<String> result = new ArrayList<String>();
        for (Object e : echos) {
            System.out.println(e);
            result.add(e.toString());
        }
        return result;
    }

    public static void main(String[] args) {
        int port = 8099;
        if (args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        new TcpEchoClient(port).sendEchos();
    }
}

