/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.wordcounter;

import io.netty.buffer.ByteBuf;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public final class WordCounterServer {
    static final int DEFAULT_PORT = 8097;
    private final int port;

    public WordCounterServer(int port) {
        this.port = port;
    }

    public HttpServer<ByteBuf, ByteBuf> createServer() {
        HttpServer server = RxNetty.createHttpServer((int)this.port, (RequestHandler)new RequestHandler<ByteBuf, ByteBuf>(){

            public Observable<Void> handle(HttpServerRequest<ByteBuf> request, final HttpServerResponse<ByteBuf> response) {
                return request.getContent().map((Func1)new Func1<ByteBuf, String>(){

                    public String call(ByteBuf content) {
                        return content.toString(Charset.defaultCharset());
                    }
                }).lift((Observable.Operator)new WordSplitOperator()).count().flatMap((Func1)new Func1<Integer, Observable<Void>>(){

                    public Observable<Void> call(Integer counter) {
                        response.writeString(counter.toString());
                        return response.close(false);
                    }
                });
            }
        });
        System.out.println("Started word counter server...");
        return server;
    }

    public static void main(String[] args) {
        new WordCounterServer(8097).createServer().startAndWait();
    }

    static class WordSplitOperator
    implements Observable.Operator<String, String> {
        private static final Pattern WORD_BOUNDARIES = Pattern.compile("[^\\w]{1,}");
        private String lastFragment = "";

        WordSplitOperator() {
        }

        public Subscriber<? super String> call(final Subscriber<? super String> child) {
            return new Subscriber<String>(){

                public void onCompleted() {
                    if (!lastFragment.isEmpty()) {
                        child.onNext((Object)lastFragment);
                    }
                    child.onCompleted();
                }

                public void onError(Throwable e) {
                    child.onError(e);
                }

                public void onNext(String text) {
                    if (text.isEmpty()) {
                        return;
                    }
                    String[] words = WORD_BOUNDARIES.split(lastFragment + text);
                    int take = words.length;
                    if (Character.isLetter(text.charAt(text.length() - 1))) {
                        lastFragment = words[--take];
                    } else {
                        lastFragment = "";
                    }
                    for (int i = 0; i < take; ++i) {
                        child.onNext((Object)words[i]);
                    }
                }
            };
        }
    }
}

