/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.websocket;

import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.protocol.http.websocket.WebSocketServerBuilder;
import io.reactivex.netty.server.RxServer;

public class WebSocketHelloServer
extends ExamplesEnvironment {
    static final int DEFAULT_PORT = 8090;
    private final int port;

    public WebSocketHelloServer(int port) {
        this.port = port;
    }

    public RxServer<WebSocketFrame, WebSocketFrame> createServer() {
        return ((WebSocketServerBuilder)RxNetty.newWebSocketServerBuilder((int)this.port, connection -> connection.getInput().flatMap(wsFrame -> {
            TextWebSocketFrame textFrame = (TextWebSocketFrame)wsFrame;
            System.out.println("Got message: " + textFrame.text());
            return connection.writeAndFlush((Object)new TextWebSocketFrame(textFrame.text().toUpperCase() + "-PONG"));
        })).enableWireLogging(LogLevel.ERROR)).build();
    }

    public static void main(String[] args) {
        new WebSocketHelloServer(8090).createServer().startAndWait();
    }
}

