/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.ssl;

import io.netty.buffer.ByteBuf;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.pipeline.ssl.DefaultFactories;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerBuilder;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import rx.Observable;

public final class SslHelloWorldServer {
    static final int DEFAULT_PORT = 8105;
    private final int port;

    public SslHelloWorldServer(int port) {
        this.port = port;
    }

    public HttpServer<ByteBuf, ByteBuf> createServer() {
        HttpServer server = ((HttpServerBuilder)RxNetty.newHttpServerBuilder((int)this.port, (RequestHandler)new RequestHandler<ByteBuf, ByteBuf>(){

            public Observable<Void> handle(HttpServerRequest<ByteBuf> request, HttpServerResponse<ByteBuf> response) {
                response.writeStringAndFlush("Welcome!!");
                return response.close(false);
            }
        }).withSslEngineFactory(DefaultFactories.selfSigned())).build();
        System.out.println("HTTP hello world server started...");
        return server;
    }

    public static void main(String[] args) {
        try {
            new SslHelloWorldServer(8105).createServer().startAndWait();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

