/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.post;

import io.netty.buffer.ByteBuf;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerBuilder;
import io.reactivex.netty.protocol.http.server.HttpServerPipelineConfigurator;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import java.nio.charset.Charset;
import rx.Observable;
import rx.functions.Func1;

public class SimplePostServer {
    static final int DEFAULT_PORT = 8102;
    private final int port;

    public SimplePostServer(int port) {
        this.port = port;
    }

    public HttpServer<ByteBuf, ByteBuf> createServer() {
        HttpServer server = ((HttpServerBuilder)((HttpServerBuilder)RxNetty.newHttpServerBuilder((int)this.port, (RequestHandler)new RequestHandler<ByteBuf, ByteBuf>(){

            public Observable<Void> handle(HttpServerRequest<ByteBuf> request, final HttpServerResponse<ByteBuf> response) {
                return request.getContent().map((Func1)new Func1<ByteBuf, Void>(){

                    public Void call(ByteBuf byteBuf) {
                        response.writeString(byteBuf.toString(Charset.defaultCharset()).toUpperCase());
                        return null;
                    }
                }).ignoreElements();
            }
        }).pipelineConfigurator((PipelineConfigurator)new HttpServerPipelineConfigurator())).enableWireLogging(LogLevel.ERROR)).build();
        System.out.println("Simple POST server started...");
        return server;
    }

    public static void main(String[] args) {
        new SimplePostServer(8102).createServer().startAndWait();
    }
}

