/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.post;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.channel.ContentTransformer;
import io.reactivex.netty.channel.StringTransformer;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.pipeline.PipelineConfigurators;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientBuilder;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import java.nio.charset.Charset;
import rx.Observable;
import rx.functions.Func1;

public class SimplePostClient {
    static final String MESSAGE = "Hello there!!!";
    private final int port;

    public SimplePostClient(int port) {
        this.port = port;
    }

    public String postMessage() {
        PipelineConfigurator pipelineConfigurator = PipelineConfigurators.httpClientConfigurator();
        HttpClient client = (HttpClient)((HttpClientBuilder)((HttpClientBuilder)RxNetty.newHttpClientBuilder((String)"localhost", (int)this.port).pipelineConfigurator(pipelineConfigurator)).enableWireLogging(LogLevel.ERROR)).build();
        HttpClientRequest request = HttpClientRequest.create((HttpMethod)HttpMethod.POST, (String)"test/post");
        request.withRawContentSource(Observable.just((Object)MESSAGE), (ContentTransformer)StringTransformer.DEFAULT_INSTANCE);
        String result = (String)client.submit(request).flatMap((Func1)new Func1<HttpClientResponse<ByteBuf>, Observable<String>>(){

            public Observable<String> call(HttpClientResponse<ByteBuf> response) {
                return response.getContent().map((Func1)new Func1<ByteBuf, String>(){

                    public String call(ByteBuf byteBuf) {
                        return byteBuf.toString(Charset.defaultCharset());
                    }
                });
            }
        }).toBlocking().single();
        return result;
    }

    public static void main(String[] args) {
        System.out.println("Sending POST request to the server...");
        String replyMessage = new SimplePostClient(8102).postMessage();
        System.out.println("Received " + replyMessage);
    }
}

